/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.FileUtils;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.CommandReload;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.metadata.pack.ResourcePackInfo;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.storage.SavedFile;
import org.slf4j.Logger;

public class CommandDatapack {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_PACK = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.datapack.unknown", var0));
    private static final DynamicCommandExceptionType ERROR_PACK_ALREADY_ENABLED = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.datapack.enable.failed", var0));
    private static final DynamicCommandExceptionType ERROR_PACK_ALREADY_DISABLED = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.datapack.disable.failed", var0));
    private static final DynamicCommandExceptionType ERROR_CANNOT_DISABLE_FEATURE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.datapack.disable.failed.feature", var0));
    private static final Dynamic2CommandExceptionType ERROR_PACK_FEATURES_NOT_ENABLED = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("commands.datapack.enable.failed.no_flags", var0, var1));
    private static final DynamicCommandExceptionType ERROR_PACK_INVALID_NAME = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.datapack.create.invalid_name", var0));
    private static final DynamicCommandExceptionType ERROR_PACK_INVALID_FULL_NAME = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.datapack.create.invalid_full_name", var0));
    private static final DynamicCommandExceptionType ERROR_PACK_ALREADY_EXISTS = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.datapack.create.already_exists", var0));
    private static final Dynamic2CommandExceptionType ERROR_PACK_METADATA_ENCODE_FAILURE = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("commands.datapack.create.metadata_encode_failure", var0, var1));
    private static final DynamicCommandExceptionType ERROR_PACK_IO_FAILURE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.datapack.create.io_failure", var0));
    private static final SuggestionProvider<CommandListenerWrapper> SELECTED_PACKS = (var0, var1) -> ICompletionProvider.suggest(((CommandListenerWrapper)var0.getSource()).getServer().getPackRepository().getSelectedIds().stream().map(StringArgumentType::escapeIfRequired), var1);
    private static final SuggestionProvider<CommandListenerWrapper> UNSELECTED_PACKS = (var0, var12) -> {
        ResourcePackRepository var2 = ((CommandListenerWrapper)var0.getSource()).getServer().getPackRepository();
        Collection<String> var3 = var2.getSelectedIds();
        FeatureFlagSet var4 = ((CommandListenerWrapper)var0.getSource()).enabledFeatures();
        return ICompletionProvider.suggest(var2.getAvailablePacks().stream().filter(var1 -> var1.getRequestedFeatures().isSubsetOf(var4)).map(ResourcePackLoader::getId).filter(var1 -> !var3.contains(var1)).map(StringArgumentType::escapeIfRequired), var12);
    };

    public static void register(CommandDispatcher<CommandListenerWrapper> var03, CommandBuildContext var1) {
        var03.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("datapack").requires(net.minecraft.commands.CommandDispatcher.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.literal("enable").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("name", StringArgumentType.string()).suggests(UNSELECTED_PACKS).executes(var02 -> CommandDatapack.enablePack((CommandListenerWrapper)var02.getSource(), CommandDatapack.getPack((CommandContext<CommandListenerWrapper>)var02, "name", true), (var0, var1) -> var1.getDefaultPosition().insert(var0, var1, ResourcePackLoader::selectionConfig, false)))).then(net.minecraft.commands.CommandDispatcher.literal("after").then(net.minecraft.commands.CommandDispatcher.argument("existing", StringArgumentType.string()).suggests(SELECTED_PACKS).executes(var0 -> CommandDatapack.enablePack((CommandListenerWrapper)var0.getSource(), CommandDatapack.getPack((CommandContext<CommandListenerWrapper>)var0, "name", true), (var1, var2) -> var1.add(var1.indexOf(CommandDatapack.getPack((CommandContext<CommandListenerWrapper>)var0, "existing", false)) + 1, var2)))))).then(net.minecraft.commands.CommandDispatcher.literal("before").then(net.minecraft.commands.CommandDispatcher.argument("existing", StringArgumentType.string()).suggests(SELECTED_PACKS).executes(var0 -> CommandDatapack.enablePack((CommandListenerWrapper)var0.getSource(), CommandDatapack.getPack((CommandContext<CommandListenerWrapper>)var0, "name", true), (var1, var2) -> var1.add(var1.indexOf(CommandDatapack.getPack((CommandContext<CommandListenerWrapper>)var0, "existing", false)), var2)))))).then(net.minecraft.commands.CommandDispatcher.literal("last").executes(var0 -> CommandDatapack.enablePack((CommandListenerWrapper)var0.getSource(), CommandDatapack.getPack((CommandContext<CommandListenerWrapper>)var0, "name", true), List::add)))).then(net.minecraft.commands.CommandDispatcher.literal("first").executes(var02 -> CommandDatapack.enablePack((CommandListenerWrapper)var02.getSource(), CommandDatapack.getPack((CommandContext<CommandListenerWrapper>)var02, "name", true), (var0, var1) -> var0.add(0, var1))))))).then(net.minecraft.commands.CommandDispatcher.literal("disable").then(net.minecraft.commands.CommandDispatcher.argument("name", StringArgumentType.string()).suggests(SELECTED_PACKS).executes(var0 -> CommandDatapack.disablePack((CommandListenerWrapper)var0.getSource(), CommandDatapack.getPack((CommandContext<CommandListenerWrapper>)var0, "name", false)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("list").executes(var0 -> CommandDatapack.listPacks((CommandListenerWrapper)var0.getSource()))).then(net.minecraft.commands.CommandDispatcher.literal("available").executes(var0 -> CommandDatapack.listAvailablePacks((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.literal("enabled").executes(var0 -> CommandDatapack.listEnabledPacks((CommandListenerWrapper)var0.getSource()))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("create").requires(net.minecraft.commands.CommandDispatcher.hasPermission(4))).then(net.minecraft.commands.CommandDispatcher.argument("id", StringArgumentType.string()).then(net.minecraft.commands.CommandDispatcher.argument("description", ArgumentChatComponent.textComponent(var1)).executes(var0 -> CommandDatapack.createPack((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"id"), ArgumentChatComponent.getResolvedComponent((CommandContext<CommandListenerWrapper>)var0, "description")))))));
    }

    private static int createPack(CommandListenerWrapper var0, String var1, IChatBaseComponent var2) throws CommandSyntaxException {
        Path var3 = var0.getServer().getWorldPath(SavedFile.DATAPACK_DIR);
        if (!FileUtils.isValidStrictPathSegment(var1)) {
            throw ERROR_PACK_INVALID_NAME.create((Object)var1);
        }
        if (!FileUtils.isPathPartPortable(var1)) {
            throw ERROR_PACK_INVALID_FULL_NAME.create((Object)var1);
        }
        Path var4 = var3.resolve(var1);
        if (Files.exists(var4, new LinkOption[0])) {
            throw ERROR_PACK_ALREADY_EXISTS.create((Object)var1);
        }
        ResourcePackInfo var5 = new ResourcePackInfo(var2, SharedConstants.getCurrentVersion().packVersion(EnumResourcePackType.SERVER_DATA).minorRange());
        DataResult var6 = ResourcePackInfo.SERVER_TYPE.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)var5);
        Optional var7 = var6.error();
        if (var7.isPresent()) {
            throw ERROR_PACK_METADATA_ENCODE_FAILURE.create((Object)var1, (Object)((DataResult.Error)var7.get()).message());
        }
        JsonObject var8 = new JsonObject();
        var8.add(ResourcePackInfo.SERVER_TYPE.name(), (JsonElement)var6.getOrThrow());
        try {
            Files.createDirectory(var4, new FileAttribute[0]);
            Files.createDirectory(var4.resolve(EnumResourcePackType.SERVER_DATA.getDirectory()), new FileAttribute[0]);
            try (BufferedWriter var9 = Files.newBufferedWriter(var4.resolve("pack.mcmeta"), StandardCharsets.UTF_8, new OpenOption[0]);
                 JsonWriter var10 = new JsonWriter((Writer)var9);){
                var10.setSerializeNulls(false);
                var10.setIndent("  ");
                ChatDeserializer.writeValue(var10, (JsonElement)var8, null);
            }
        }
        catch (IOException var9) {
            LOGGER.warn("Failed to create pack at {}", (Object)var3.toAbsolutePath(), (Object)var9);
            throw ERROR_PACK_IO_FAILURE.create((Object)var1);
        }
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.datapack.create.success", var1), true);
        return 1;
    }

    private static int enablePack(CommandListenerWrapper var0, ResourcePackLoader var1, a var2) throws CommandSyntaxException {
        ResourcePackRepository var3 = var0.getServer().getPackRepository();
        ArrayList var4 = Lists.newArrayList(var3.getSelectedPacks());
        var2.apply(var4, var1);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.datapack.modify.enable", var1.getChatLink(true)), true);
        CommandReload.reloadPacks(var4.stream().map(ResourcePackLoader::getId).collect(Collectors.toList()), var0);
        return var4.size();
    }

    private static int disablePack(CommandListenerWrapper var0, ResourcePackLoader var1) {
        ResourcePackRepository var2 = var0.getServer().getPackRepository();
        ArrayList var3 = Lists.newArrayList(var2.getSelectedPacks());
        var3.remove(var1);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.datapack.modify.disable", var1.getChatLink(true)), true);
        CommandReload.reloadPacks(var3.stream().map(ResourcePackLoader::getId).collect(Collectors.toList()), var0);
        return var3.size();
    }

    private static int listPacks(CommandListenerWrapper var0) {
        return CommandDatapack.listEnabledPacks(var0) + CommandDatapack.listAvailablePacks(var0);
    }

    private static int listAvailablePacks(CommandListenerWrapper var0) {
        ResourcePackRepository var1 = var0.getServer().getPackRepository();
        var1.reload();
        Collection<ResourcePackLoader> var22 = var1.getSelectedPacks();
        Collection<ResourcePackLoader> var3 = var1.getAvailablePacks();
        FeatureFlagSet var4 = var0.enabledFeatures();
        List<ResourcePackLoader> var5 = var3.stream().filter(var2 -> !var22.contains(var2) && var2.getRequestedFeatures().isSubsetOf(var4)).toList();
        if (var5.isEmpty()) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.datapack.list.available.none"), false);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.datapack.list.available.success", var5.size(), ChatComponentUtils.formatList(var5, var0 -> var0.getChatLink(false))), false);
        }
        return var5.size();
    }

    private static int listEnabledPacks(CommandListenerWrapper var0) {
        ResourcePackRepository var1 = var0.getServer().getPackRepository();
        var1.reload();
        Collection<ResourcePackLoader> var2 = var1.getSelectedPacks();
        if (var2.isEmpty()) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.datapack.list.enabled.none"), false);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.datapack.list.enabled.success", var2.size(), ChatComponentUtils.formatList(var2, var0 -> var0.getChatLink(true))), false);
        }
        return var2.size();
    }

    private static ResourcePackLoader getPack(CommandContext<CommandListenerWrapper> var0, String var1, boolean var2) throws CommandSyntaxException {
        String var3 = StringArgumentType.getString(var0, (String)var1);
        ResourcePackRepository var4 = ((CommandListenerWrapper)var0.getSource()).getServer().getPackRepository();
        ResourcePackLoader var5 = var4.getPack(var3);
        if (var5 == null) {
            throw ERROR_UNKNOWN_PACK.create((Object)var3);
        }
        boolean var6 = var4.getSelectedPacks().contains(var5);
        if (var2 && var6) {
            throw ERROR_PACK_ALREADY_ENABLED.create((Object)var3);
        }
        if (!var2 && !var6) {
            throw ERROR_PACK_ALREADY_DISABLED.create((Object)var3);
        }
        FeatureFlagSet var7 = ((CommandListenerWrapper)var0.getSource()).enabledFeatures();
        FeatureFlagSet var8 = var5.getRequestedFeatures();
        if (!var2 && !var8.isEmpty() && var5.getPackSource() == PackSource.FEATURE) {
            throw ERROR_CANNOT_DISABLE_FEATURE.create((Object)var3);
        }
        if (!var8.isSubsetOf(var7)) {
            throw ERROR_PACK_FEATURES_NOT_ENABLED.create((Object)var3, (Object)FeatureFlags.printMissingFlags(var7, var8));
        }
        return var5;
    }

    static interface a {
        public void apply(List<ResourcePackLoader> var1, ResourcePackLoader var2) throws CommandSyntaxException;
    }
}

