/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.ScoreboardTeam;

public class CommandTeamMsg {
    private static final ChatModifier SUGGEST_STYLE = ChatModifier.EMPTY.withHoverEvent(new ChatHoverable.e(IChatBaseComponent.translatable("chat.type.team.hover"))).withClickEvent(new ChatClickable.SuggestCommand("/teammsg "));
    private static final SimpleCommandExceptionType ERROR_NOT_ON_TEAM = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.teammsg.failed.noteam"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        LiteralCommandNode var1 = var02.register((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("teammsg").then(net.minecraft.commands.CommandDispatcher.argument("message", ArgumentChat.message()).executes(var0 -> {
            CommandListenerWrapper var1 = (CommandListenerWrapper)var0.getSource();
            Entity var22 = var1.getEntityOrException();
            ScoreboardTeam var3 = var22.getTeam();
            if (var3 == null) {
                throw ERROR_NOT_ON_TEAM.create();
            }
            List<EntityPlayer> var42 = var1.getServer().getPlayerList().getPlayers().stream().filter(var2 -> var2 == var22 || var2.getTeam() == var3).toList();
            if (!var42.isEmpty()) {
                ArgumentChat.resolveChatMessage((CommandContext<CommandListenerWrapper>)var0, "message", var4 -> CommandTeamMsg.sendMessage(var1, var22, var3, var42, var4));
            }
            return var42.size();
        })));
        var02.register((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("tm").redirect((CommandNode)var1));
    }

    private static void sendMessage(CommandListenerWrapper var0, Entity var1, ScoreboardTeam var2, List<EntityPlayer> var3, PlayerChatMessage var4) {
        IChatMutableComponent var5 = var2.getFormattedDisplayName().withStyle(SUGGEST_STYLE);
        ChatMessageType.a var6 = ChatMessageType.bind(ChatMessageType.TEAM_MSG_COMMAND_INCOMING, var0).withTargetName(var5);
        ChatMessageType.a var7 = ChatMessageType.bind(ChatMessageType.TEAM_MSG_COMMAND_OUTGOING, var0).withTargetName(var5);
        OutgoingChatMessage var8 = OutgoingChatMessage.create(var4);
        boolean var9 = false;
        for (EntityPlayer var11 : var3) {
            ChatMessageType.a var12 = var11 == var1 ? var7 : var6;
            boolean var13 = var0.shouldFilterMessageTo(var11);
            var11.sendChatMessage(var8, var13, var12);
            var9 |= var13 && var4.isFullyFiltered();
        }
        if (var9) {
            var0.sendSystemMessage(PlayerList.CHAT_FILTERED_FULL);
        }
    }
}

