/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands.data;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.commands.data.CommandDataAccessor;
import net.minecraft.world.level.storage.PersistentCommandStorage;

public class CommandDataStorage
implements CommandDataAccessor {
    static final SuggestionProvider<CommandListenerWrapper> SUGGEST_STORAGE = (var0, var1) -> ICompletionProvider.suggestResource(CommandDataStorage.getGlobalTags((CommandContext<CommandListenerWrapper>)var0).keys(), var1);
    public static final Function<String, CommandData.c> PROVIDER = var0 -> new CommandData.c((String)var0){
        final /* synthetic */ String a;
        {
            this.a = string;
        }

        @Override
        public CommandDataAccessor access(CommandContext<CommandListenerWrapper> var0) {
            return new CommandDataStorage(CommandDataStorage.getGlobalTags(var0), ArgumentMinecraftKeyRegistered.getId(var0, this.a));
        }

        @Override
        public ArgumentBuilder<CommandListenerWrapper, ?> wrap(ArgumentBuilder<CommandListenerWrapper, ?> var0, Function<ArgumentBuilder<CommandListenerWrapper, ?>, ArgumentBuilder<CommandListenerWrapper, ?>> var1) {
            return var0.then(CommandDispatcher.literal("storage").then(var1.apply((ArgumentBuilder<CommandListenerWrapper, ?>)CommandDispatcher.argument(this.a, ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_STORAGE))));
        }
    };
    private final PersistentCommandStorage storage;
    private final MinecraftKey id;

    static PersistentCommandStorage getGlobalTags(CommandContext<CommandListenerWrapper> var0) {
        return ((CommandListenerWrapper)var0.getSource()).getServer().getCommandStorage();
    }

    CommandDataStorage(PersistentCommandStorage var0, MinecraftKey var1) {
        this.storage = var0;
        this.id = var1;
    }

    @Override
    public void setData(NBTTagCompound var0) {
        this.storage.set(this.id, var0);
    }

    @Override
    public NBTTagCompound getData() {
        return this.storage.get(this.id);
    }

    @Override
    public IChatBaseComponent getModifiedSuccess() {
        return IChatBaseComponent.translatable("commands.data.storage.modified", IChatBaseComponent.translationArg(this.id));
    }

    @Override
    public IChatBaseComponent getPrintSuccess(NBTBase var0) {
        return IChatBaseComponent.translatable("commands.data.storage.query", IChatBaseComponent.translationArg(this.id), GameProfileSerializer.toPrettyComponent(var0));
    }

    @Override
    public IChatBaseComponent getPrintSuccess(ArgumentNBTKey.g var0, double var1, int var3) {
        return IChatBaseComponent.translatable("commands.data.storage.get", var0.asString(), IChatBaseComponent.translationArg(this.id), String.format(Locale.ROOT, "%.2f", var1), var3);
    }
}

