/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.internalapi;

import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.jsonrpc.JsonRpcLogger;
import net.minecraft.server.jsonrpc.internalapi.MinecraftGameRuleService;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.GameRulesService;
import net.minecraft.server.jsonrpc.methods.InvalidParameterJsonRpcException;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.GameRules;

public class MinecraftGameRuleServiceImpl
implements MinecraftGameRuleService {
    private final DedicatedServer server;
    private final JsonRpcLogger jsonrpcLogger;

    public MinecraftGameRuleServiceImpl(DedicatedServer var0, JsonRpcLogger var1) {
        this.server = var0;
        this.jsonrpcLogger = var1;
    }

    @Override
    public GameRulesService.b updateGameRule(GameRulesService.c var0, ClientInfo var1) {
        Object var5;
        GameRules.GameRuleValue<?> var2 = this.getRuleValue(var0.key());
        String var3 = var2.serialize();
        if (var2 instanceof GameRules.GameRuleBoolean) {
            var5 = (GameRules.GameRuleBoolean)var2;
            ((GameRules.GameRuleBoolean)var5).set(Boolean.parseBoolean(var0.value()), this.server);
        } else if (var2 instanceof GameRules.GameRuleInt) {
            GameRules.GameRuleInt var4 = (GameRules.GameRuleInt)var2;
            var4.set(Integer.parseInt(var0.value()), this.server);
        } else {
            throw new InvalidParameterJsonRpcException("Unknown rule type for key: " + var0.key());
        }
        var5 = this.getTypedRule(var0.key(), var2);
        this.jsonrpcLogger.log(var1, "Game rule '{}' updated from '{}' to '{}'", ((GameRulesService.b)var5).key(), var3, ((GameRulesService.b)var5).value());
        this.server.onGameRuleChanged(var0.key(), var2);
        return var5;
    }

    @Override
    public <T extends GameRules.GameRuleValue<T>> T getRule(GameRules.GameRuleKey<T> var0) {
        return this.server.getGameRules().getRule(var0);
    }

    @Override
    public GameRulesService.b getTypedRule(String var0, GameRules.GameRuleValue<?> var1) {
        GameRules.GameRuleValue<?> gameRuleValue = var1;
        Objects.requireNonNull(gameRuleValue);
        GameRules.GameRuleValue<?> gameRuleValue2 = gameRuleValue;
        int n2 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GameRules.GameRuleBoolean.class, GameRules.GameRuleInt.class}, gameRuleValue2, n2)) {
            case 0 -> {
                GameRules.GameRuleBoolean var4 = (GameRules.GameRuleBoolean)gameRuleValue2;
                yield new GameRulesService.b(var0, String.valueOf(var4.get()), GameRulesService.a.BOOL);
            }
            case 1 -> {
                GameRules.GameRuleInt var5 = (GameRules.GameRuleInt)gameRuleValue2;
                yield new GameRulesService.b(var0, String.valueOf(var5.get()), GameRulesService.a.INT);
            }
            default -> throw new InvalidParameterJsonRpcException("Unknown rule type");
        };
    }

    @Override
    public Stream<Map.Entry<GameRules.GameRuleKey<?>, GameRules.GameRuleDefinition<?>>> getAvailableGameRules() {
        FeatureFlagSet var0 = this.server.getWorldData().getLevelSettings().getDataConfiguration().enabledFeatures();
        return GameRules.availableRules(var0);
    }

    private Optional<GameRules.GameRuleKey<?>> getRuleKey(String var0) {
        Stream<Map.Entry<GameRules.GameRuleKey<?>, GameRules.GameRuleDefinition<?>>> var12 = this.getAvailableGameRules();
        return var12.filter(var1 -> ((GameRules.GameRuleKey)var1.getKey()).getId().equals(var0)).findFirst().map(Map.Entry::getKey);
    }

    private GameRules.GameRuleValue<?> getRuleValue(String var0) {
        GameRules.GameRuleKey<?> var1 = this.getRuleKey(var0).orElseThrow(() -> new InvalidParameterJsonRpcException("Game rule '" + var0 + "' does not exist"));
        return this.server.getGameRules().getRule(var1);
    }
}

