/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.server.jsonrpc.api.PlayerDto;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.Message;
import net.minecraft.server.jsonrpc.methods.PlayerService;
import net.minecraft.server.level.EntityPlayer;

public class ServerStateService {
    public static a status(MinecraftApi var0) {
        if (!var0.serverStateService().isReady()) {
            return a.NOT_STARTED;
        }
        return new a(true, PlayerService.get(var0), ServerPing.ServerData.current());
    }

    public static boolean save(MinecraftApi var0, boolean var1, ClientInfo var2) {
        return var0.serverStateService().saveEverything(true, var1, true, var2);
    }

    public static boolean stop(MinecraftApi var0, ClientInfo var1) {
        var0.submit(() -> var0.serverStateService().halt(false, var1));
        return true;
    }

    public static boolean systemMessage(MinecraftApi var0, b var1, ClientInfo var2) {
        IChatBaseComponent var3 = var1.message().asComponent().orElse(null);
        if (var3 == null) {
            return false;
        }
        if (var1.receivingPlayers().isPresent()) {
            if (var1.receivingPlayers().get().isEmpty()) {
                return false;
            }
            for (PlayerDto var5 : var1.receivingPlayers().get()) {
                EntityPlayer var6;
                if (var5.id().isPresent()) {
                    var6 = var0.playerListService().getPlayer(var5.id().get());
                } else {
                    if (!var5.name().isPresent()) continue;
                    var6 = var0.playerListService().getPlayerByName(var5.name().get());
                }
                if (var6 == null) continue;
                var6.sendSystemMessage(var3, var1.overlay());
            }
        } else {
            var0.serverStateService().broadcastSystemMessage(var3, var1.overlay(), var2);
        }
        return true;
    }

    public record a(boolean started, List<PlayerDto> players, ServerPing.ServerData version) {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.BOOL.fieldOf("started").forGetter(a::started), (App)PlayerDto.CODEC.codec().listOf().lenientOptionalFieldOf("players", List.of()).forGetter(a::players), (App)ServerPing.ServerData.CODEC.fieldOf("version").forGetter(a::version)).apply((Applicative)var0, a::new));
        public static final a NOT_STARTED = new a(false, List.of(), ServerPing.ServerData.current());
    }

    public record b(Message message, boolean overlay, Optional<List<PlayerDto>> receivingPlayers) {
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Message.CODEC.fieldOf("message").forGetter(b::message), (App)Codec.BOOL.fieldOf("overlay").forGetter(b::overlay), (App)PlayerDto.CODEC.codec().listOf().lenientOptionalFieldOf("receivingPlayers").forGetter(b::receivingPlayers)).apply((Applicative)var0, b::new));
    }
}

