/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.ping.ServerboundPingRequestPacket;
import net.minecraft.network.protocol.status.PacketStatusInListener;
import net.minecraft.network.protocol.status.PacketStatusInStart;
import net.minecraft.network.protocol.status.PacketStatusOutServerInfo;
import net.minecraft.network.protocol.status.ServerPing;

public class PacketStatusListener
implements PacketStatusInListener {
    private static final IChatBaseComponent DISCONNECT_REASON = IChatBaseComponent.translatable("multiplayer.status.request_handled");
    private final ServerPing status;
    private final NetworkManager connection;
    private boolean hasRequestedStatus;

    public PacketStatusListener(ServerPing var0, NetworkManager var1) {
        this.status = var0;
        this.connection = var1;
    }

    @Override
    public void onDisconnect(DisconnectionDetails var0) {
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected();
    }

    @Override
    public void handleStatusRequest(PacketStatusInStart var0) {
        if (this.hasRequestedStatus) {
            this.connection.disconnect(DISCONNECT_REASON);
            return;
        }
        this.hasRequestedStatus = true;
        this.connection.send(new PacketStatusOutServerInfo(this.status));
    }

    @Override
    public void handlePingRequest(ServerboundPingRequestPacket var0) {
        this.connection.send(new ClientboundPongResponsePacket(var0.getTime()));
        this.connection.disconnect(DISCONNECT_REASON);
    }
}

