/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.linkfs;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.server.packs.linkfs.DummyFileAttributes;
import net.minecraft.server.packs.linkfs.LinkFileSystem;
import net.minecraft.server.packs.linkfs.PathContents;

class LinkFSPath
implements Path {
    private static final BasicFileAttributes DIRECTORY_ATTRIBUTES = new DummyFileAttributes(){

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }
    };
    private static final BasicFileAttributes FILE_ATTRIBUTES = new DummyFileAttributes(){

        @Override
        public boolean isRegularFile() {
            return true;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }
    };
    private static final Comparator<LinkFSPath> PATH_COMPARATOR = Comparator.comparing(LinkFSPath::pathToString);
    private final String name;
    private final LinkFileSystem fileSystem;
    @Nullable
    private final LinkFSPath parent;
    @Nullable
    private List<String> pathToRoot;
    @Nullable
    private String pathString;
    private final PathContents pathContents;

    public LinkFSPath(LinkFileSystem var0, String var1, @Nullable LinkFSPath var2, PathContents var3) {
        this.fileSystem = var0;
        this.name = var1;
        this.parent = var2;
        this.pathContents = var3;
    }

    private LinkFSPath createRelativePath(@Nullable LinkFSPath var0, String var1) {
        return new LinkFSPath(this.fileSystem, var1, var0, PathContents.RELATIVE);
    }

    @Override
    public LinkFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.pathContents != PathContents.RELATIVE;
    }

    @Override
    public File toFile() {
        PathContents pathContents = this.pathContents;
        if (pathContents instanceof PathContents.b) {
            PathContents.b var0 = (PathContents.b)pathContents;
            return var0.contents().toFile();
        }
        throw new UnsupportedOperationException("Path " + this.pathToString() + " does not represent file");
    }

    @Override
    @Nullable
    public LinkFSPath getRoot() {
        if (this.isAbsolute()) {
            return this.fileSystem.rootPath();
        }
        return null;
    }

    @Override
    public LinkFSPath getFileName() {
        return this.createRelativePath(null, this.name);
    }

    @Override
    @Nullable
    public LinkFSPath getParent() {
        return this.parent;
    }

    @Override
    public int getNameCount() {
        return this.pathToRoot().size();
    }

    private List<String> pathToRoot() {
        if (this.name.isEmpty()) {
            return List.of();
        }
        if (this.pathToRoot == null) {
            ImmutableList.Builder var0 = ImmutableList.builder();
            if (this.parent != null) {
                var0.addAll(this.parent.pathToRoot());
            }
            var0.add((Object)this.name);
            this.pathToRoot = var0.build();
        }
        return this.pathToRoot;
    }

    @Override
    public LinkFSPath getName(int var0) {
        List<String> var1 = this.pathToRoot();
        if (var0 < 0 || var0 >= var1.size()) {
            throw new IllegalArgumentException("Invalid index: " + var0);
        }
        return this.createRelativePath(null, var1.get(var0));
    }

    @Override
    public LinkFSPath subpath(int var0, int var1) {
        List<String> var2 = this.pathToRoot();
        if (var0 < 0 || var1 > var2.size() || var0 >= var1) {
            throw new IllegalArgumentException();
        }
        LinkFSPath var3 = null;
        for (int var4 = var0; var4 < var1; ++var4) {
            var3 = this.createRelativePath(var3, var2.get(var4));
        }
        return var3;
    }

    @Override
    public boolean startsWith(Path var0) {
        if (var0.isAbsolute() != this.isAbsolute()) {
            return false;
        }
        if (var0 instanceof LinkFSPath) {
            LinkFSPath var1 = (LinkFSPath)var0;
            if (var1.fileSystem != this.fileSystem) {
                return false;
            }
            List<String> var2 = this.pathToRoot();
            List<String> var3 = var1.pathToRoot();
            int var4 = var3.size();
            if (var4 > var2.size()) {
                return false;
            }
            for (int var5 = 0; var5 < var4; ++var5) {
                if (var3.get(var5).equals(var2.get(var5))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean endsWith(Path var0) {
        if (var0.isAbsolute() && !this.isAbsolute()) {
            return false;
        }
        if (var0 instanceof LinkFSPath) {
            LinkFSPath var1 = (LinkFSPath)var0;
            if (var1.fileSystem != this.fileSystem) {
                return false;
            }
            List<String> var2 = this.pathToRoot();
            List<String> var3 = var1.pathToRoot();
            int var4 = var3.size();
            int var5 = var2.size() - var4;
            if (var5 < 0) {
                return false;
            }
            for (int var6 = var4 - 1; var6 >= 0; --var6) {
                if (var3.get(var6).equals(var2.get(var5 + var6))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public LinkFSPath normalize() {
        return this;
    }

    @Override
    public LinkFSPath resolve(Path var0) {
        LinkFSPath var1 = this.toLinkPath(var0);
        if (var0.isAbsolute()) {
            return var1;
        }
        return this.resolve(var1.pathToRoot());
    }

    private LinkFSPath resolve(List<String> var0) {
        LinkFSPath var1 = this;
        for (String var3 : var0) {
            var1 = var1.resolveName(var3);
        }
        return var1;
    }

    LinkFSPath resolveName(String var0) {
        if (LinkFSPath.isRelativeOrMissing(this.pathContents)) {
            return new LinkFSPath(this.fileSystem, var0, this, this.pathContents);
        }
        PathContents pathContents = this.pathContents;
        if (pathContents instanceof PathContents.a) {
            PathContents.a var1 = (PathContents.a)pathContents;
            LinkFSPath var2 = var1.children().get(var0);
            return var2 != null ? var2 : new LinkFSPath(this.fileSystem, var0, this, PathContents.MISSING);
        }
        if (this.pathContents instanceof PathContents.b) {
            return new LinkFSPath(this.fileSystem, var0, this, PathContents.MISSING);
        }
        throw new AssertionError((Object)"All content types should be already handled");
    }

    private static boolean isRelativeOrMissing(PathContents var0) {
        return var0 == PathContents.MISSING || var0 == PathContents.RELATIVE;
    }

    @Override
    public LinkFSPath relativize(Path var0) {
        LinkFSPath var1 = this.toLinkPath(var0);
        if (this.isAbsolute() != var1.isAbsolute()) {
            throw new IllegalArgumentException("absolute mismatch");
        }
        List<String> var2 = this.pathToRoot();
        List<String> var3 = var1.pathToRoot();
        if (var2.size() >= var3.size()) {
            throw new IllegalArgumentException();
        }
        for (int var4 = 0; var4 < var2.size(); ++var4) {
            if (var2.get(var4).equals(var3.get(var4))) continue;
            throw new IllegalArgumentException();
        }
        return var1.subpath(var2.size(), var3.size());
    }

    @Override
    public URI toUri() {
        try {
            return new URI("x-mc-link", this.fileSystem.store().name(), this.pathToString(), null);
        }
        catch (URISyntaxException var0) {
            throw new AssertionError("Failed to create URI", var0);
        }
    }

    @Override
    public LinkFSPath toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return this.fileSystem.rootPath().resolve(this);
    }

    @Override
    public LinkFSPath toRealPath(LinkOption ... var0) {
        return this.toAbsolutePath();
    }

    @Override
    public WatchKey register(WatchService var0, WatchEvent.Kind<?>[] var1, WatchEvent.Modifier ... var2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(Path var0) {
        LinkFSPath var1 = this.toLinkPath(var0);
        return PATH_COMPARATOR.compare(this, var1);
    }

    @Override
    public boolean equals(Object var0) {
        if (var0 == this) {
            return true;
        }
        if (var0 instanceof LinkFSPath) {
            LinkFSPath var1 = (LinkFSPath)var0;
            if (this.fileSystem != var1.fileSystem) {
                return false;
            }
            boolean var2 = this.hasRealContents();
            if (var2 != var1.hasRealContents()) {
                return false;
            }
            if (var2) {
                return this.pathContents == var1.pathContents;
            }
            return Objects.equals(this.parent, var1.parent) && Objects.equals(this.name, var1.name);
        }
        return false;
    }

    private boolean hasRealContents() {
        return !LinkFSPath.isRelativeOrMissing(this.pathContents);
    }

    @Override
    public int hashCode() {
        return this.hasRealContents() ? this.pathContents.hashCode() : this.name.hashCode();
    }

    @Override
    public String toString() {
        return this.pathToString();
    }

    private String pathToString() {
        if (this.pathString == null) {
            StringBuilder var0 = new StringBuilder();
            if (this.isAbsolute()) {
                var0.append("/");
            }
            Joiner.on((String)"/").appendTo(var0, this.pathToRoot());
            this.pathString = var0.toString();
        }
        return this.pathString;
    }

    private LinkFSPath toLinkPath(@Nullable Path var0) {
        if (var0 == null) {
            throw new NullPointerException();
        }
        if (var0 instanceof LinkFSPath) {
            LinkFSPath var1 = (LinkFSPath)var0;
            if (var1.fileSystem == this.fileSystem) {
                return var1;
            }
        }
        throw new ProviderMismatchException();
    }

    public boolean exists() {
        return this.hasRealContents();
    }

    @Nullable
    public Path getTargetPath() {
        Path path;
        PathContents pathContents = this.pathContents;
        if (pathContents instanceof PathContents.b) {
            PathContents.b var0 = (PathContents.b)pathContents;
            path = var0.contents();
        } else {
            path = null;
        }
        return path;
    }

    @Nullable
    public PathContents.a getDirectoryContents() {
        PathContents.a var0;
        PathContents pathContents = this.pathContents;
        return pathContents instanceof PathContents.a ? (var0 = (PathContents.a)pathContents) : null;
    }

    public BasicFileAttributeView getBasicAttributeView() {
        return new BasicFileAttributeView(){

            @Override
            public String name() {
                return "basic";
            }

            @Override
            public BasicFileAttributes readAttributes() throws IOException {
                return LinkFSPath.this.getBasicAttributes();
            }

            @Override
            public void setTimes(FileTime var0, FileTime var1, FileTime var2) {
                throw new ReadOnlyFileSystemException();
            }
        };
    }

    public BasicFileAttributes getBasicAttributes() throws IOException {
        if (this.pathContents instanceof PathContents.a) {
            return DIRECTORY_ATTRIBUTES;
        }
        if (this.pathContents instanceof PathContents.b) {
            return FILE_ATTRIBUTES;
        }
        throw new NoSuchFileException(this.pathToString());
    }

    @Override
    public /* synthetic */ Path toRealPath(LinkOption[] linkOptionArray) throws IOException {
        return this.toRealPath(linkOptionArray);
    }

    @Override
    public /* synthetic */ Path toAbsolutePath() {
        return this.toAbsolutePath();
    }

    @Override
    public /* synthetic */ Path relativize(Path path) {
        return this.relativize(path);
    }

    @Override
    public /* synthetic */ Path resolve(Path path) {
        return this.resolve(path);
    }

    @Override
    public /* synthetic */ Path normalize() {
        return this.normalize();
    }

    @Override
    public /* synthetic */ Path subpath(int n2, int n3) {
        return this.subpath(n2, n3);
    }

    @Override
    public /* synthetic */ Path getName(int n2) {
        return this.getName(n2);
    }

    @Override
    @Nullable
    public /* synthetic */ Path getParent() {
        return this.getParent();
    }

    @Override
    public /* synthetic */ Path getFileName() {
        return this.getFileName();
    }

    @Override
    @Nullable
    public /* synthetic */ Path getRoot() {
        return this.getRoot();
    }

    @Override
    public /* synthetic */ FileSystem getFileSystem() {
        return this.getFileSystem();
    }
}

