/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.metadata.pack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.metadata.pack.PackFormat;
import net.minecraft.util.InclusiveRange;

public record ResourcePackInfo(IChatBaseComponent description, InclusiveRange<PackFormat> supportedFormats) {
    private static final Codec<ResourcePackInfo> FALLBACK_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)ComponentSerialization.CODEC.fieldOf("description").forGetter(ResourcePackInfo::description)).apply((Applicative)var02, var0 -> new ResourcePackInfo((IChatBaseComponent)var0, new InclusiveRange<PackFormat>(PackFormat.of(Integer.MAX_VALUE)))));
    public static final MetadataSectionType<ResourcePackInfo> CLIENT_TYPE = new MetadataSectionType<ResourcePackInfo>("pack", ResourcePackInfo.codecForPackType(EnumResourcePackType.CLIENT_RESOURCES));
    public static final MetadataSectionType<ResourcePackInfo> SERVER_TYPE = new MetadataSectionType<ResourcePackInfo>("pack", ResourcePackInfo.codecForPackType(EnumResourcePackType.SERVER_DATA));
    public static final MetadataSectionType<ResourcePackInfo> FALLBACK_TYPE = new MetadataSectionType<ResourcePackInfo>("pack", FALLBACK_CODEC);

    private static Codec<ResourcePackInfo> codecForPackType(EnumResourcePackType var0) {
        return RecordCodecBuilder.create(var1 -> var1.group((App)ComponentSerialization.CODEC.fieldOf("description").forGetter(ResourcePackInfo::description), (App)PackFormat.packCodec(var0).forGetter(ResourcePackInfo::supportedFormats)).apply((Applicative)var1, ResourcePackInfo::new));
    }

    public static MetadataSectionType<ResourcePackInfo> forPackType(EnumResourcePackType var0) {
        return switch (var0) {
            default -> throw new MatchException(null, null);
            case EnumResourcePackType.CLIENT_RESOURCES -> CLIENT_TYPE;
            case EnumResourcePackType.SERVER_DATA -> SERVER_TYPE;
        };
    }
}

