/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Locale;

public record ColorRGBA(int rgba) {
    private static final String CUSTOM_COLOR_PREFIX = "#";
    public static final Codec<ColorRGBA> CODEC = Codec.STRING.comapFlatMap(var0 -> {
        if (!var0.startsWith(CUSTOM_COLOR_PREFIX)) {
            return DataResult.error(() -> "Not a color code: " + var0);
        }
        try {
            int var1 = (int)Long.parseLong(var0.substring(1), 16);
            return DataResult.success((Object)new ColorRGBA(var1));
        }
        catch (NumberFormatException var1) {
            return DataResult.error(() -> "Exception parsing color code: " + var1.getMessage());
        }
    }, ColorRGBA::formatValue);

    private String formatValue() {
        return String.format(Locale.ROOT, "#%08X", this.rgba);
    }

    @Override
    public String toString() {
        return this.formatValue();
    }
}

