/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import java.util.function.Supplier;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterEntityName;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class ThrownPotionSplitFix
extends DataConverterEntityName {
    private final Supplier<a> itemIdFinder = Suppliers.memoize(() -> {
        Type var0 = this.getInputSchema().getChoiceType(DataConverterTypes.ENTITY, "minecraft:potion");
        Type<?> var1 = ExtraDataFixUtils.patchSubType(var0, this.getInputSchema().getType(DataConverterTypes.ENTITY), this.getOutputSchema().getType(DataConverterTypes.ENTITY));
        OpticFinder var2 = var1.findField("Item");
        OpticFinder var3 = DSL.fieldFinder((String)"id", (Type)DSL.named((String)DataConverterTypes.ITEM_NAME.typeName(), DataConverterSchemaNamed.namespacedString()));
        return new a(var2, (OpticFinder<Pair<String, String>>)var3);
    });

    public ThrownPotionSplitFix(Schema var0) {
        super("ThrownPotionSplitFix", var0, true);
    }

    @Override
    protected Pair<String, Typed<?>> fix(String var0, Typed<?> var1) {
        if (!var0.equals("minecraft:potion")) {
            return Pair.of((Object)var0, var1);
        }
        String var2 = this.itemIdFinder.get().getItemId(var1);
        if ("minecraft:lingering_potion".equals(var2)) {
            return Pair.of((Object)"minecraft:lingering_potion", var1);
        }
        return Pair.of((Object)"minecraft:splash_potion", var1);
    }

    record a(OpticFinder<?> itemFinder, OpticFinder<Pair<String, String>> itemIdFinder) {
        public String getItemId(Typed<?> var02) {
            return var02.getOptionalTyped(this.itemFinder).flatMap(var0 -> var0.getOptional(this.itemIdFinder)).map(Pair::getSecond).map(DataConverterSchemaNamed::ensureNamespaced).orElse("");
        }
    }
}

