/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat.commands;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.parsing.packrat.DelayedException;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Rule;
import net.minecraft.util.parsing.packrat.commands.ResourceSuggestion;

public abstract class ResourceLookupRule<C, V>
implements Rule<StringReader, V>,
ResourceSuggestion {
    private final NamedRule<StringReader, MinecraftKey> idParser;
    protected final C context;
    private final DelayedException<CommandSyntaxException> error;

    protected ResourceLookupRule(NamedRule<StringReader, MinecraftKey> var0, C var1) {
        this.idParser = var0;
        this.context = var1;
        this.error = DelayedException.create(MinecraftKey.ERROR_INVALID);
    }

    @Override
    @Nullable
    public V parse(ParseState<StringReader> var0) {
        var0.input().skipWhitespace();
        int var1 = var0.mark();
        MinecraftKey var2 = var0.parse(this.idParser);
        if (var2 != null) {
            try {
                return this.validateElement((ImmutableStringReader)var0.input(), var2);
            }
            catch (Exception var3) {
                var0.errorCollector().store(var1, this, var3);
                return null;
            }
        }
        var0.errorCollector().store(var1, this, this.error);
        return null;
    }

    protected abstract V validateElement(ImmutableStringReader var1, MinecraftKey var2) throws Exception;
}

