/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr;

import com.mojang.logging.LogUtils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.util.profiling.jfr.parse.JfrStatsParser;
import net.minecraft.util.profiling.jfr.parse.JfrStatsResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class SummaryReporter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Runnable onDeregistration;

    protected SummaryReporter(Runnable var0) {
        this.onDeregistration = var0;
    }

    public void recordingStopped(@Nullable Path var0) {
        JfrStatsResult var1;
        if (var0 == null) {
            return;
        }
        this.onDeregistration.run();
        SummaryReporter.infoWithFallback(() -> "Dumped flight recorder profiling to " + String.valueOf(var0));
        try {
            var1 = JfrStatsParser.parse(var0);
        }
        catch (Throwable var2) {
            SummaryReporter.warnWithFallback(() -> "Failed to parse JFR recording", var2);
            return;
        }
        try {
            SummaryReporter.infoWithFallback(var1::asJson);
            Path var2 = var0.resolveSibling("jfr-report-" + StringUtils.substringBefore((String)var0.getFileName().toString(), (String)".jfr") + ".json");
            Files.writeString(var2, (CharSequence)var1.asJson(), StandardOpenOption.CREATE);
            SummaryReporter.infoWithFallback(() -> "Dumped recording summary to " + String.valueOf(var2));
        }
        catch (Throwable var2) {
            SummaryReporter.warnWithFallback(() -> "Failed to output JFR report", var2);
        }
    }

    private static void infoWithFallback(Supplier<String> var0) {
        if (LogUtils.isLoggerActive()) {
            LOGGER.info(var0.get());
        } else {
            DispenserRegistry.realStdoutPrintln(var0.get());
        }
    }

    private static void warnWithFallback(Supplier<String> var0, Throwable var1) {
        if (LogUtils.isLoggerActive()) {
            LOGGER.warn(var0.get(), var1);
        } else {
            DispenserRegistry.realStdoutPrintln(var0.get());
            var1.printStackTrace(DispenserRegistry.STDOUT);
        }
    }
}

