/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.metrics.storage;

import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.util.profiling.metrics.MetricSampler;
import net.minecraft.util.profiling.metrics.storage.RecordedDeviation;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class MetricsPersister {
    public static final Path PROFILING_RESULTS_DIR = Paths.get("debug/profiling", new String[0]);
    public static final String METRICS_DIR_NAME = "metrics";
    public static final String DEVIATIONS_DIR_NAME = "deviations";
    public static final String PROFILING_RESULT_FILENAME = "profiling.txt";
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String rootFolderName;

    public MetricsPersister(String var0) {
        this.rootFolderName = var0;
    }

    public Path saveReports(Set<MetricSampler> var0, Map<MetricSampler, List<RecordedDeviation>> var1, MethodProfilerResults var2) {
        try {
            Files.createDirectories(PROFILING_RESULTS_DIR, new FileAttribute[0]);
        }
        catch (IOException var3) {
            throw new UncheckedIOException(var3);
        }
        try {
            Path var3 = Files.createTempDirectory("minecraft-profiling", new FileAttribute[0]);
            var3.toFile().deleteOnExit();
            Files.createDirectories(PROFILING_RESULTS_DIR, new FileAttribute[0]);
            Path var4 = var3.resolve(this.rootFolderName);
            Path var5 = var4.resolve(METRICS_DIR_NAME);
            this.saveMetrics(var0, var5);
            if (!var1.isEmpty()) {
                this.saveDeviations(var1, var4.resolve(DEVIATIONS_DIR_NAME));
            }
            this.saveProfilingTaskExecutionResult(var2, var4);
            return var3;
        }
        catch (IOException var3) {
            throw new UncheckedIOException(var3);
        }
    }

    private void saveMetrics(Set<MetricSampler> var0, Path var12) {
        if (var0.isEmpty()) {
            throw new IllegalArgumentException("Expected at least one sampler to persist");
        }
        Map<MetricCategory, List<MetricSampler>> var22 = var0.stream().collect(Collectors.groupingBy(MetricSampler::getCategory));
        var22.forEach((var1, var2) -> this.saveCategory((MetricCategory)((Object)var1), (List<MetricSampler>)var2, var12));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCategory(MetricCategory var0, List<MetricSampler> var12, Path var2) {
        Path var3 = var2.resolve(SystemUtils.sanitizeName(var0.getDescription(), MinecraftKey::validPathChar) + ".csv");
        BufferedWriter var4 = null;
        try {
            Files.createDirectories(var3.getParent(), new FileAttribute[0]);
            var4 = Files.newBufferedWriter(var3, StandardCharsets.UTF_8, new OpenOption[0]);
            CSVWriter.a var5 = CSVWriter.builder();
            var5.addColumn("@tick");
            for (MetricSampler metricSampler : var12) {
                var5.addColumn(metricSampler.getName());
            }
            CSVWriter var6 = var5.build(var4);
            List list = var12.stream().map(MetricSampler::result).collect(Collectors.toList());
            int var8 = list.stream().mapToInt(MetricSampler.b::getFirstTick).summaryStatistics().getMin();
            int var9 = list.stream().mapToInt(MetricSampler.b::getLastTick).summaryStatistics().getMax();
            for (int var10 = var8; var10 <= var9; ++var10) {
                int var11 = var10;
                Stream<String> var122 = list.stream().map(var1 -> String.valueOf(var1.valueAtTick(var11)));
                Object[] var13 = Stream.concat(Stream.of(String.valueOf(var10)), var122).toArray(String[]::new);
                var6.writeRow(var13);
            }
            LOGGER.info("Flushed metrics to {}", (Object)var3);
            IOUtils.closeQuietly((Writer)var4);
        }
        catch (Exception var5) {
            LOGGER.error("Could not save profiler results to {}", (Object)var3, (Object)var5);
        }
        finally {
            IOUtils.closeQuietly(var4);
        }
    }

    private void saveDeviations(Map<MetricSampler, List<RecordedDeviation>> var0, Path var1) {
        DateTimeFormatter var22 = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss.SSS", Locale.UK).withZone(ZoneId.systemDefault());
        var0.forEach((var2, var32) -> var32.forEach(var3 -> {
            String var4 = var22.format(var3.timestamp);
            Path var5 = var1.resolve(SystemUtils.sanitizeName(var2.getName(), MinecraftKey::validPathChar)).resolve(String.format(Locale.ROOT, "%d@%s.txt", var3.tick, var4));
            var3.profilerResultAtTick.saveResults(var5);
        }));
    }

    private void saveProfilingTaskExecutionResult(MethodProfilerResults var0, Path var1) {
        var0.saveResults(var1.resolve(PROFILING_RESULT_FILENAME));
    }
}

