/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.google.common.collect.Queues;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public interface PairedQueue<T extends Runnable> {
    @Nullable
    public Runnable pop();

    public boolean push(T var1);

    public boolean isEmpty();

    public int size();

    public static final class a
    implements PairedQueue<c> {
        private final Queue<Runnable>[] queues;
        private final AtomicInteger size = new AtomicInteger();

        public a(int var0) {
            this.queues = new Queue[var0];
            for (int var1 = 0; var1 < var0; ++var1) {
                this.queues[var1] = Queues.newConcurrentLinkedQueue();
            }
        }

        @Override
        @Nullable
        public Runnable pop() {
            for (Queue<Runnable> var3 : this.queues) {
                Runnable var4 = var3.poll();
                if (var4 == null) continue;
                this.size.decrementAndGet();
                return var4;
            }
            return null;
        }

        @Override
        public boolean push(c var0) {
            int var1 = var0.priority;
            if (var1 >= this.queues.length || var1 < 0) {
                throw new IndexOutOfBoundsException(String.format(Locale.ROOT, "Priority %d not supported. Expected range [0-%d]", var1, this.queues.length - 1));
            }
            this.queues[var1].add(var0);
            this.size.incrementAndGet();
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.size.get() == 0;
        }

        @Override
        public int size() {
            return this.size.get();
        }
    }

    public static final class c
    extends Record
    implements Runnable {
        final int priority;
        private final Runnable task;

        public c(int var0, Runnable var1) {
            this.priority = var0;
            this.task = var1;
        }

        @Override
        public void run() {
            this.task.run();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "priority;task", "priority", "task"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "priority;task", "priority", "task"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "priority;task", "priority", "task"}, this, var0);
        }

        public int priority() {
            return this.priority;
        }

        public Runnable task() {
            return this.task;
        }
    }

    public static final class b
    implements PairedQueue<Runnable> {
        private final Queue<Runnable> queue;

        public b(Queue<Runnable> var0) {
            this.queue = var0;
        }

        @Override
        @Nullable
        public Runnable pop() {
            return this.queue.poll();
        }

        @Override
        public boolean push(Runnable var0) {
            return this.queue.add(var0);
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public int size() {
            return this.queue.size();
        }
    }
}

