/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;

class WeavingMobEffect
extends MobEffectList {
    private final ToIntFunction<RandomSource> maxCobwebs;

    protected WeavingMobEffect(MobEffectInfo var0, int var1, ToIntFunction<RandomSource> var2) {
        super(var0, var1, Particles.ITEM_COBWEB);
        this.maxCobwebs = var2;
    }

    @Override
    public void onMobRemoved(WorldServer var0, EntityLiving var1, int var2, Entity.RemovalReason var3) {
        if (var3 == Entity.RemovalReason.KILLED && (var1 instanceof EntityHuman || var0.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING))) {
            this.spawnCobwebsRandomlyAround(var0, var1.getRandom(), var1.blockPosition());
        }
    }

    private void spawnCobwebsRandomlyAround(WorldServer var0, RandomSource var1, BlockPosition var2) {
        HashSet var3 = Sets.newHashSet();
        int var4 = this.maxCobwebs.applyAsInt(var1);
        for (BlockPosition var6 : BlockPosition.randomInCube(var1, 15, var2, 1)) {
            BlockPosition var7 = var6.below();
            if (var3.contains(var6) || !var0.getBlockState(var6).canBeReplaced() || !var0.getBlockState(var7).isFaceSturdy(var0, var7, EnumDirection.UP)) continue;
            var3.add(var6.immutable());
            if (var3.size() < var4) continue;
            break;
        }
        for (BlockPosition var6 : var3) {
            var0.setBlock(var6, Blocks.COBWEB.defaultBlockState(), 3);
            var0.levelEvent(3018, var6, 0);
        }
    }
}

