/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class EntityAgeable
extends EntityCreature {
    private static final DataWatcherObject<Boolean> DATA_BABY_ID = DataWatcher.defineId(EntityAgeable.class, DataWatcherRegistry.BOOLEAN);
    public static final int BABY_START_AGE = -24000;
    private static final int FORCED_AGE_PARTICLE_TICKS = 40;
    protected static final int DEFAULT_AGE = 0;
    protected static final int DEFAULT_FORCED_AGE = 0;
    protected int age = 0;
    protected int forcedAge = 0;
    protected int forcedAgeTimer;

    protected EntityAgeable(EntityTypes<? extends EntityAgeable> var0, World var1) {
        super((EntityTypes<? extends EntityCreature>)var0, var1);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        a var4;
        if (var3 == null) {
            var3 = new a(true);
        }
        if ((var4 = (a)var3).isShouldSpawnBaby() && var4.getGroupSize() > 0 && var0.getRandom().nextFloat() <= var4.getBabySpawnChance()) {
            this.setAge(-24000);
        }
        var4.increaseGroupSizeByOne();
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Nullable
    public abstract EntityAgeable getBreedOffspring(WorldServer var1, EntityAgeable var2);

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_BABY_ID, false);
    }

    public boolean canBreed() {
        return false;
    }

    public int getAge() {
        if (this.level().isClientSide()) {
            return this.entityData.get(DATA_BABY_ID) != false ? -1 : 1;
        }
        return this.age;
    }

    public void ageUp(int var0, boolean var1) {
        int var2;
        int var3 = var2 = this.getAge();
        if ((var2 += var0 * 20) > 0) {
            var2 = 0;
        }
        int var4 = var2 - var3;
        this.setAge(var2);
        if (var1) {
            this.forcedAge += var4;
            if (this.forcedAgeTimer == 0) {
                this.forcedAgeTimer = 40;
            }
        }
        if (this.getAge() == 0) {
            this.setAge(this.forcedAge);
        }
    }

    public void ageUp(int var0) {
        this.ageUp(var0, false);
    }

    public void setAge(int var0) {
        int var1 = this.getAge();
        this.age = var0;
        if (var1 < 0 && var0 >= 0 || var1 >= 0 && var0 < 0) {
            this.entityData.set(DATA_BABY_ID, var0 < 0);
            this.ageBoundaryReached();
        }
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("Age", this.getAge());
        var0.putInt("ForcedAge", this.forcedAge);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.setAge(var0.getIntOr("Age", 0));
        this.forcedAge = var0.getIntOr("ForcedAge", 0);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_BABY_ID.equals(var0)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(var0);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide()) {
            if (this.forcedAgeTimer > 0) {
                if (this.forcedAgeTimer % 4 == 0) {
                    this.level().addParticle(Particles.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
                }
                --this.forcedAgeTimer;
            }
        } else if (this.isAlive()) {
            int var0 = this.getAge();
            if (var0 < 0) {
                this.setAge(++var0);
            } else if (var0 > 0) {
                this.setAge(--var0);
            }
        }
    }

    protected void ageBoundaryReached() {
        AbstractBoat var0;
        Entity entity;
        if (!this.isBaby() && this.isPassenger() && (entity = this.getVehicle()) instanceof AbstractBoat && !(var0 = (AbstractBoat)entity).hasEnoughSpaceFor(this)) {
            this.stopRiding();
        }
    }

    @Override
    public boolean isBaby() {
        return this.getAge() < 0;
    }

    @Override
    public void setBaby(boolean var0) {
        this.setAge(var0 ? -24000 : 0);
    }

    public static int getSpeedUpSecondsWhenFeeding(int var0) {
        return (int)((float)(var0 / 20) * 0.1f);
    }

    @VisibleForTesting
    public int getForcedAge() {
        return this.forcedAge;
    }

    @VisibleForTesting
    public int getForcedAgeTimer() {
        return this.forcedAgeTimer;
    }

    public static class a
    implements GroupDataEntity {
        private int groupSize;
        private final boolean shouldSpawnBaby;
        private final float babySpawnChance;

        public a(boolean var0, float var1) {
            this.shouldSpawnBaby = var0;
            this.babySpawnChance = var1;
        }

        public a(boolean var0) {
            this(var0, 0.05f);
        }

        public a(float var0) {
            this(true, var0);
        }

        public int getGroupSize() {
            return this.groupSize;
        }

        public void increaseGroupSizeByOne() {
            ++this.groupSize;
        }

        public boolean isShouldSpawnBaby() {
            return this.shouldSpawnBaby;
        }

        public float getBabySpawnChance() {
            return this.babySpawnChance;
        }
    }
}

