/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.serialization.Codec;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.ItemStack;

public class EntityEquipment {
    public static final Codec<EntityEquipment> CODEC = Codec.unboundedMap(EnumItemSlot.CODEC, ItemStack.CODEC).xmap(var0 -> {
        EnumMap<EnumItemSlot, ItemStack> var1 = new EnumMap<EnumItemSlot, ItemStack>(EnumItemSlot.class);
        var1.putAll((Map<EnumItemSlot, ItemStack>)var0);
        return new EntityEquipment(var1);
    }, var0 -> {
        EnumMap<EnumItemSlot, ItemStack> var1 = new EnumMap<EnumItemSlot, ItemStack>(var0.items);
        var1.values().removeIf(ItemStack::isEmpty);
        return var1;
    });
    private final EnumMap<EnumItemSlot, ItemStack> items;

    private EntityEquipment(EnumMap<EnumItemSlot, ItemStack> var0) {
        this.items = var0;
    }

    public EntityEquipment() {
        this(new EnumMap<EnumItemSlot, ItemStack>(EnumItemSlot.class));
    }

    public ItemStack set(EnumItemSlot var0, ItemStack var1) {
        return Objects.requireNonNullElse(this.items.put(var0, var1), ItemStack.EMPTY);
    }

    public ItemStack get(EnumItemSlot var0) {
        return this.items.getOrDefault(var0, ItemStack.EMPTY);
    }

    public boolean isEmpty() {
        for (ItemStack var1 : this.items.values()) {
            if (var1.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void tick(Entity var0) {
        for (Map.Entry<EnumItemSlot, ItemStack> var2 : this.items.entrySet()) {
            ItemStack var3 = var2.getValue();
            if (var3.isEmpty()) continue;
            var3.inventoryTick(var0.level(), var0, var2.getKey());
        }
    }

    public void setAll(EntityEquipment var0) {
        this.items.clear();
        this.items.putAll(var0.items);
    }

    public void dropAll(EntityLiving var0) {
        for (ItemStack var2 : this.items.values()) {
            var0.drop(var2, true, false);
        }
        this.clear();
    }

    public void clear() {
        this.items.replaceAll((var0, var1) -> ItemStack.EMPTY);
    }
}

