/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockSoil;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;

public class BehaviorFarm
extends Behavior<EntityVillager> {
    private static final int HARVEST_DURATION = 200;
    public static final float SPEED_MODIFIER = 0.5f;
    @Nullable
    private BlockPosition aboveFarmlandPos;
    private long nextOkStartTime;
    private int timeWorkedSoFar;
    private final List<BlockPosition> validFarmlandAroundVillager = Lists.newArrayList();

    public BehaviorFarm() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.SECONDARY_JOB_SITE, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityVillager var1) {
        if (!var0.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            return false;
        }
        if (!var1.getVillagerData().profession().is(VillagerProfession.FARMER)) {
            return false;
        }
        BlockPosition.MutableBlockPosition var2 = var1.blockPosition().mutable();
        this.validFarmlandAroundVillager.clear();
        for (int var3 = -1; var3 <= 1; ++var3) {
            for (int var4 = -1; var4 <= 1; ++var4) {
                for (int var5 = -1; var5 <= 1; ++var5) {
                    var2.set(var1.getX() + (double)var3, var1.getY() + (double)var4, var1.getZ() + (double)var5);
                    if (!this.validPos(var2, var0)) continue;
                    this.validFarmlandAroundVillager.add(new BlockPosition(var2));
                }
            }
        }
        this.aboveFarmlandPos = this.getValidFarmland(var0);
        return this.aboveFarmlandPos != null;
    }

    @Nullable
    private BlockPosition getValidFarmland(WorldServer var0) {
        return this.validFarmlandAroundVillager.isEmpty() ? null : this.validFarmlandAroundVillager.get(var0.getRandom().nextInt(this.validFarmlandAroundVillager.size()));
    }

    private boolean validPos(BlockPosition var0, WorldServer var1) {
        IBlockData var2 = var1.getBlockState(var0);
        Block var3 = var2.getBlock();
        Block var4 = var1.getBlockState(var0.below()).getBlock();
        return var3 instanceof BlockCrops && ((BlockCrops)var3).isMaxAge(var2) || var2.isAir() && var4 instanceof BlockSoil;
    }

    @Override
    protected void start(WorldServer var0, EntityVillager var1, long var2) {
        if (var2 > this.nextOkStartTime && this.aboveFarmlandPos != null) {
            var1.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorTarget(this.aboveFarmlandPos));
            var1.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(new BehaviorTarget(this.aboveFarmlandPos), 0.5f, 1));
        }
    }

    @Override
    protected void stop(WorldServer var0, EntityVillager var1, long var2) {
        var1.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        var1.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        this.timeWorkedSoFar = 0;
        this.nextOkStartTime = var2 + 40L;
    }

    @Override
    protected void tick(WorldServer var0, EntityVillager var1, long var2) {
        if (this.aboveFarmlandPos != null && !this.aboveFarmlandPos.closerToCenterThan(var1.position(), 1.0)) {
            return;
        }
        if (this.aboveFarmlandPos != null && var2 > this.nextOkStartTime) {
            IBlockData var4 = var0.getBlockState(this.aboveFarmlandPos);
            Block var5 = var4.getBlock();
            Block var6 = var0.getBlockState(this.aboveFarmlandPos.below()).getBlock();
            if (var5 instanceof BlockCrops && ((BlockCrops)var5).isMaxAge(var4)) {
                var0.destroyBlock(this.aboveFarmlandPos, true, var1);
            }
            if (var4.isAir() && var6 instanceof BlockSoil && var1.hasFarmSeeds()) {
                InventorySubcontainer var7 = var1.getInventory();
                for (int var8 = 0; var8 < var7.getContainerSize(); ++var8) {
                    Item item;
                    ItemStack var9 = var7.getItem(var8);
                    boolean var10 = false;
                    if (!var9.isEmpty() && var9.is(TagsItem.VILLAGER_PLANTABLE_SEEDS) && (item = var9.getItem()) instanceof ItemBlock) {
                        ItemBlock var11 = (ItemBlock)item;
                        IBlockData var12 = var11.getBlock().defaultBlockState();
                        var0.setBlockAndUpdate(this.aboveFarmlandPos, var12);
                        var0.gameEvent(GameEvent.BLOCK_PLACE, this.aboveFarmlandPos, GameEvent.a.of(var1, var12));
                        var10 = true;
                    }
                    if (!var10) continue;
                    var0.playSound(null, (double)this.aboveFarmlandPos.getX(), (double)this.aboveFarmlandPos.getY(), (double)this.aboveFarmlandPos.getZ(), SoundEffects.CROP_PLANTED, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    var9.shrink(1);
                    if (!var9.isEmpty()) break;
                    var7.setItem(var8, ItemStack.EMPTY);
                    break;
                }
            }
            if (var5 instanceof BlockCrops && !((BlockCrops)var5).isMaxAge(var4)) {
                this.validFarmlandAroundVillager.remove(this.aboveFarmlandPos);
                this.aboveFarmlandPos = this.getValidFarmland(var0);
                if (this.aboveFarmlandPos != null) {
                    this.nextOkStartTime = var2 + 20L;
                    var1.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(new BehaviorTarget(this.aboveFarmlandPos), 0.5f, 1));
                    var1.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorTarget(this.aboveFarmlandPos));
                }
            }
        }
        ++this.timeWorkedSoFar;
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityVillager var1, long var2) {
        return this.timeWorkedSoFar < 200;
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (EntityVillager)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityVillager)entityLiving, l2);
    }
}

