/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorFindPosition;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.level.pathfinder.PathEntity;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;

public class BehaviorWalkHome {
    private static final int CACHE_TIMEOUT = 40;
    private static final int BATCH_SIZE = 5;
    private static final int RATE = 20;
    private static final int OK_DISTANCE_SQR = 4;

    public static BehaviorControl<EntityCreature> create(float var0) {
        Long2LongOpenHashMap var1 = new Long2LongOpenHashMap();
        MutableLong var2 = new MutableLong(0L);
        return BehaviorBuilder.create(arg_0 -> BehaviorWalkHome.a(var2, (Long2LongMap)var1, var0, arg_0));
    }

    private static /* synthetic */ App a(MutableLong var0, Long2LongMap var1, float var2, BehaviorBuilder.b var32) {
        return var32.group(var32.absent(MemoryModuleType.WALK_TARGET), var32.absent(MemoryModuleType.HOME)).apply((Applicative)var32, (var3, var42) -> (var4, var5, var6) -> {
            if (var4.getGameTime() - var0.getValue() < 20L) {
                return false;
            }
            VillagePlace var8 = var4.getPoiManager();
            Optional<BlockPosition> var9 = var8.findClosest(var0 -> var0.is(PoiTypes.HOME), var5.blockPosition(), 48, VillagePlace.Occupancy.ANY);
            if (var9.isEmpty() || var9.get().distSqr(var5.blockPosition()) <= 4.0) {
                return false;
            }
            MutableInt var10 = new MutableInt(0);
            var0.setValue(var4.getGameTime() + (long)var4.getRandom().nextInt(20));
            Predicate<BlockPosition> var11 = var3 -> {
                WorldServer var4 = var3.asLong();
                if (var1.containsKey(var4)) {
                    return false;
                }
                if (var10.incrementAndGet() >= 5) {
                    return false;
                }
                var1.put(var4, var0.getValue() + 40L);
                return true;
            };
            Set<Pair<Holder<VillagePlaceType>, BlockPosition>> var122 = var8.findAllWithType(var0 -> var0.is(PoiTypes.HOME), var11, var5.blockPosition(), 48, VillagePlace.Occupancy.ANY).collect(Collectors.toSet());
            PathEntity var13 = BehaviorFindPosition.findPathToPois(var5, var122);
            if (var13 != null && var13.canReach()) {
                BlockPosition var14 = var13.getTarget();
                Optional<Holder<VillagePlaceType>> var15 = var8.getType(var14);
                if (var15.isPresent()) {
                    var3.set(new MemoryTarget(var14, var2, 1));
                    var4.debugSynchronizers().updatePoi(var14);
                }
            } else if (var10.getValue() < 5) {
                var1.long2LongEntrySet().removeIf(var1 -> var1.getLongValue() < var0.getValue());
            }
            return true;
        });
    }
}

