/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.phys.Vec3D;

public class PathfinderGoalStrollVillageGolem
extends PathfinderGoalRandomStroll {
    private static final int POI_SECTION_SCAN_RADIUS = 2;
    private static final int VILLAGER_SCAN_RADIUS = 32;
    private static final int RANDOM_POS_XY_DISTANCE = 10;
    private static final int RANDOM_POS_Y_DISTANCE = 7;

    public PathfinderGoalStrollVillageGolem(EntityCreature var0, double var1) {
        super(var0, var1, 240, false);
    }

    @Override
    @Nullable
    protected Vec3D getPosition() {
        Vec3D var0;
        float var1 = this.mob.level().random.nextFloat();
        if (this.mob.level().random.nextFloat() < 0.3f) {
            return this.getPositionTowardsAnywhere();
        }
        if (var1 < 0.7f) {
            var0 = this.getPositionTowardsVillagerWhoWantsGolem();
            if (var0 == null) {
                var0 = this.getPositionTowardsPoi();
            }
        } else {
            var0 = this.getPositionTowardsPoi();
            if (var0 == null) {
                var0 = this.getPositionTowardsVillagerWhoWantsGolem();
            }
        }
        return var0 == null ? this.getPositionTowardsAnywhere() : var0;
    }

    @Nullable
    private Vec3D getPositionTowardsAnywhere() {
        return LandRandomPos.getPos(this.mob, 10, 7);
    }

    @Nullable
    private Vec3D getPositionTowardsVillagerWhoWantsGolem() {
        WorldServer var0 = (WorldServer)this.mob.level();
        List<EntityVillager> var1 = var0.getEntities(EntityTypes.VILLAGER, this.mob.getBoundingBox().inflate(32.0), this::doesVillagerWantGolem);
        if (var1.isEmpty()) {
            return null;
        }
        EntityVillager var2 = var1.get(this.mob.level().random.nextInt(var1.size()));
        Vec3D var3 = var2.position();
        return LandRandomPos.getPosTowards(this.mob, 10, 7, var3);
    }

    @Nullable
    private Vec3D getPositionTowardsPoi() {
        SectionPosition var0 = this.getRandomVillageSection();
        if (var0 == null) {
            return null;
        }
        BlockPosition var1 = this.getRandomPoiWithinSection(var0);
        if (var1 == null) {
            return null;
        }
        return LandRandomPos.getPosTowards(this.mob, 10, 7, Vec3D.atBottomCenterOf(var1));
    }

    @Nullable
    private SectionPosition getRandomVillageSection() {
        WorldServer var0 = (WorldServer)this.mob.level();
        List var12 = SectionPosition.cube(SectionPosition.of(this.mob), 2).filter(var1 -> var0.sectionsToVillage((SectionPosition)var1) == 0).collect(Collectors.toList());
        if (var12.isEmpty()) {
            return null;
        }
        return (SectionPosition)var12.get(var0.random.nextInt(var12.size()));
    }

    @Nullable
    private BlockPosition getRandomPoiWithinSection(SectionPosition var02) {
        WorldServer var1 = (WorldServer)this.mob.level();
        VillagePlace var2 = var1.getPoiManager();
        List var3 = var2.getInRange(var0 -> true, var02.center(), 8, VillagePlace.Occupancy.IS_OCCUPIED).map(VillagePlaceRecord::getPos).collect(Collectors.toList());
        if (var3.isEmpty()) {
            return null;
        }
        return (BlockPosition)var3.get(var1.random.nextInt(var3.size()));
    }

    private boolean doesVillagerWantGolem(EntityVillager var0) {
        return var0.wantsToSpawnGolem(this.mob.level().getGameTime());
    }
}

