/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal.target;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.AxisAlignedBB;

public class PathfinderGoalUniversalAngerReset<T extends EntityInsentient>
extends PathfinderGoal {
    private static final int ALERT_RANGE_Y = 10;
    private final T mob;
    private final boolean alertOthersOfSameType;
    private int lastHurtByPlayerTimestamp;

    public PathfinderGoalUniversalAngerReset(T var0, boolean var1) {
        this.mob = var0;
        this.alertOthersOfSameType = var1;
    }

    @Override
    public boolean canUse() {
        return PathfinderGoalUniversalAngerReset.getServerLevel(this.mob).getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER) && this.wasHurtByPlayer();
    }

    private boolean wasHurtByPlayer() {
        return ((EntityLiving)this.mob).getLastHurtByMob() != null && ((EntityLiving)this.mob).getLastHurtByMob().getType() == EntityTypes.PLAYER && ((EntityLiving)this.mob).getLastHurtByMobTimestamp() > this.lastHurtByPlayerTimestamp;
    }

    @Override
    public void start() {
        this.lastHurtByPlayerTimestamp = ((EntityLiving)this.mob).getLastHurtByMobTimestamp();
        ((IEntityAngerable)this.mob).forgetCurrentTargetAndRefreshUniversalAnger();
        if (this.alertOthersOfSameType) {
            this.getNearbyMobsOfSameType().stream().filter(var0 -> var0 != this.mob).map(var0 -> (IEntityAngerable)((Object)var0)).forEach(IEntityAngerable::forgetCurrentTargetAndRefreshUniversalAnger);
        }
        super.start();
    }

    private List<? extends EntityInsentient> getNearbyMobsOfSameType() {
        double var0 = ((EntityLiving)this.mob).getAttributeValue(GenericAttributes.FOLLOW_RANGE);
        AxisAlignedBB var2 = AxisAlignedBB.unitCubeFromLowerCorner(((Entity)this.mob).position()).inflate(var0, 10.0, var0);
        return ((Entity)this.mob).level().getEntitiesOfClass(this.mob.getClass(), var2, IEntitySelector.NO_SPECTATORS);
    }
}

