/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;

public abstract class Sensor<E extends EntityLiving> {
    private static final RandomSource RANDOM = RandomSource.createThreadSafe();
    private static final int DEFAULT_SCAN_RATE = 20;
    private static final int DEFAULT_TARGETING_RANGE = 16;
    private static final PathfinderTargetCondition TARGET_CONDITIONS = PathfinderTargetCondition.forNonCombat().range(16.0);
    private static final PathfinderTargetCondition TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING = PathfinderTargetCondition.forNonCombat().range(16.0).ignoreInvisibilityTesting();
    private static final PathfinderTargetCondition ATTACK_TARGET_CONDITIONS = PathfinderTargetCondition.forCombat().range(16.0);
    private static final PathfinderTargetCondition ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING = PathfinderTargetCondition.forCombat().range(16.0).ignoreInvisibilityTesting();
    private static final PathfinderTargetCondition ATTACK_TARGET_CONDITIONS_IGNORE_LINE_OF_SIGHT = PathfinderTargetCondition.forCombat().range(16.0).ignoreLineOfSight();
    private static final PathfinderTargetCondition ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_AND_LINE_OF_SIGHT = PathfinderTargetCondition.forCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();
    private final int scanRate;
    private long timeToTick;

    public Sensor(int var0) {
        this.scanRate = var0;
        this.timeToTick = RANDOM.nextInt(var0);
    }

    public Sensor() {
        this(20);
    }

    public final void tick(WorldServer var0, E var1) {
        if (--this.timeToTick <= 0L) {
            this.timeToTick = this.scanRate;
            this.updateTargetingConditionRanges(var1);
            this.doTick(var0, var1);
        }
    }

    private void updateTargetingConditionRanges(E var0) {
        double var1 = ((EntityLiving)var0).getAttributeValue(GenericAttributes.FOLLOW_RANGE);
        TARGET_CONDITIONS.range(var1);
        TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING.range(var1);
        ATTACK_TARGET_CONDITIONS.range(var1);
        ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING.range(var1);
        ATTACK_TARGET_CONDITIONS_IGNORE_LINE_OF_SIGHT.range(var1);
        ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_AND_LINE_OF_SIGHT.range(var1);
    }

    protected abstract void doTick(WorldServer var1, E var2);

    public abstract Set<MemoryModuleType<?>> requires();

    public static boolean isEntityTargetable(WorldServer var0, EntityLiving var1, EntityLiving var2) {
        if (var1.getBrain().isMemoryValue(MemoryModuleType.ATTACK_TARGET, var2)) {
            return TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING.test(var0, var1, var2);
        }
        return TARGET_CONDITIONS.test(var0, var1, var2);
    }

    public static boolean isEntityAttackable(WorldServer var0, EntityLiving var1, EntityLiving var2) {
        if (var1.getBrain().isMemoryValue(MemoryModuleType.ATTACK_TARGET, var2)) {
            return ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING.test(var0, var1, var2);
        }
        return ATTACK_TARGET_CONDITIONS.test(var0, var1, var2);
    }

    public static BiPredicate<WorldServer, EntityLiving> wasEntityAttackableLastNTicks(EntityLiving var0, int var12) {
        return Sensor.rememberPositives(var12, (var1, var2) -> Sensor.isEntityAttackable(var1, var0, var2));
    }

    public static boolean isEntityAttackableIgnoringLineOfSight(WorldServer var0, EntityLiving var1, EntityLiving var2) {
        if (var1.getBrain().isMemoryValue(MemoryModuleType.ATTACK_TARGET, var2)) {
            return ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_AND_LINE_OF_SIGHT.test(var0, var1, var2);
        }
        return ATTACK_TARGET_CONDITIONS_IGNORE_LINE_OF_SIGHT.test(var0, var1, var2);
    }

    static <T, U> BiPredicate<T, U> rememberPositives(int var0, BiPredicate<T, U> var1) {
        AtomicInteger var2 = new AtomicInteger(0);
        return (var3, var4) -> {
            if (var1.test(var3, var4)) {
                var2.set(var0);
                return true;
            }
            return var2.decrementAndGet() >= 0;
        };
    }
}

