/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;

public class VillagePlaceRecord {
    private final BlockPosition pos;
    private final Holder<VillagePlaceType> poiType;
    private int freeTickets;
    private final Runnable setDirty;

    VillagePlaceRecord(BlockPosition var0, Holder<VillagePlaceType> var1, int var2, Runnable var3) {
        this.pos = var0.immutable();
        this.poiType = var1;
        this.freeTickets = var2;
        this.setDirty = var3;
    }

    public VillagePlaceRecord(BlockPosition var0, Holder<VillagePlaceType> var1, Runnable var2) {
        this(var0, var1, var1.value().maxTickets(), var2);
    }

    public a pack() {
        return new a(this.pos, this.poiType, this.freeTickets);
    }

    @Deprecated
    @VisibleForDebug
    public int getFreeTickets() {
        return this.freeTickets;
    }

    protected boolean acquireTicket() {
        if (this.freeTickets <= 0) {
            return false;
        }
        --this.freeTickets;
        this.setDirty.run();
        return true;
    }

    protected boolean releaseTicket() {
        if (this.freeTickets >= this.poiType.value().maxTickets()) {
            return false;
        }
        ++this.freeTickets;
        this.setDirty.run();
        return true;
    }

    public boolean hasSpace() {
        return this.freeTickets > 0;
    }

    public boolean isOccupied() {
        return this.freeTickets != this.poiType.value().maxTickets();
    }

    public BlockPosition getPos() {
        return this.pos;
    }

    public Holder<VillagePlaceType> getPoiType() {
        return this.poiType;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        return Objects.equals(this.pos, ((VillagePlaceRecord)var0).pos);
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    public record a(BlockPosition pos, Holder<VillagePlaceType> poiType, int freeTickets) {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)BlockPosition.CODEC.fieldOf("pos").forGetter(a::pos), (App)RegistryFixedCodec.create(Registries.POINT_OF_INTEREST_TYPE).fieldOf("type").forGetter(a::poiType), (App)Codec.INT.fieldOf("free_tickets").orElse((Object)0).forGetter(a::freeTickets)).apply((Applicative)var0, a::new));

        public VillagePlaceRecord unpack(Runnable var0) {
            return new VillagePlaceRecord(this.pos, this.poiType, this.freeTickets, var0);
        }
    }
}

