/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon.phases;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonController;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.Vec3D;

public class DragonControllerHold
extends AbstractDragonController {
    private static final PathfinderTargetCondition NEW_TARGET_TARGETING = PathfinderTargetCondition.forCombat().ignoreLineOfSight();
    @Nullable
    private PathEntity currentPath;
    @Nullable
    private Vec3D targetLocation;
    private boolean clockwise;

    public DragonControllerHold(EntityEnderDragon var0) {
        super(var0);
    }

    public DragonControllerPhase<DragonControllerHold> getPhase() {
        return DragonControllerPhase.HOLDING_PATTERN;
    }

    @Override
    public void doServerTick(WorldServer var0) {
        double var1;
        double d2 = var1 = this.targetLocation == null ? 0.0 : this.targetLocation.distanceToSqr(this.dragon.getX(), this.dragon.getY(), this.dragon.getZ());
        if (var1 < 100.0 || var1 > 22500.0 || this.dragon.horizontalCollision || this.dragon.verticalCollision) {
            this.findNewTarget(var0);
        }
    }

    @Override
    public void begin() {
        this.currentPath = null;
        this.targetLocation = null;
    }

    @Override
    @Nullable
    public Vec3D getFlyTargetLocation() {
        return this.targetLocation;
    }

    private void findNewTarget(WorldServer var0) {
        int var2;
        if (this.currentPath != null && this.currentPath.isDone()) {
            BlockPosition var1 = var0.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, WorldGenEndTrophy.getLocation(this.dragon.getFightOrigin()));
            int n2 = var2 = this.dragon.getDragonFight() == null ? 0 : this.dragon.getDragonFight().getCrystalsAlive();
            if (this.dragon.getRandom().nextInt(var2 + 3) == 0) {
                this.dragon.getPhaseManager().setPhase(DragonControllerPhase.LANDING_APPROACH);
                return;
            }
            EntityHuman var5 = var0.getNearestPlayer(NEW_TARGET_TARGETING, this.dragon, (double)var1.getX(), (double)var1.getY(), var1.getZ());
            double var3 = var5 != null ? var1.distToCenterSqr(var5.position()) / 512.0 : 64.0;
            if (var5 != null && (this.dragon.getRandom().nextInt((int)(var3 + 2.0)) == 0 || this.dragon.getRandom().nextInt(var2 + 2) == 0)) {
                this.strafePlayer(var5);
                return;
            }
        }
        if (this.currentPath == null || this.currentPath.isDone()) {
            int var1;
            var2 = var1 = this.dragon.findClosestNode();
            if (this.dragon.getRandom().nextInt(8) == 0) {
                this.clockwise = !this.clockwise;
                var2 += 6;
            }
            var2 = this.clockwise ? ++var2 : --var2;
            if (this.dragon.getDragonFight() == null || this.dragon.getDragonFight().getCrystalsAlive() < 0) {
                var2 -= 12;
                var2 &= 7;
                var2 += 12;
            } else if ((var2 %= 12) < 0) {
                var2 += 12;
            }
            this.currentPath = this.dragon.findPath(var1, var2, null);
            if (this.currentPath != null) {
                this.currentPath.advance();
            }
        }
        this.navigateToNextPathNode();
    }

    private void strafePlayer(EntityHuman var0) {
        this.dragon.getPhaseManager().setPhase(DragonControllerPhase.STRAFE_PLAYER);
        this.dragon.getPhaseManager().getPhase(DragonControllerPhase.STRAFE_PLAYER).setTarget(var0);
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.isDone()) {
            double var5;
            BlockPosition var0 = this.currentPath.getNextNodePos();
            this.currentPath.advance();
            double var1 = var0.getX();
            double var3 = var0.getZ();
            while ((var5 = (double)((float)var0.getY() + this.dragon.getRandom().nextFloat() * 20.0f)) < (double)var0.getY()) {
            }
            this.targetLocation = new Vec3D(var1, var5, var3);
        }
    }

    @Override
    public void onCrystalDestroyed(EntityEnderCrystal var0, BlockPosition var1, DamageSource var2, @Nullable EntityHuman var3) {
        if (var3 != null && this.dragon.canAttack(var3)) {
            this.strafePlayer(var3);
        }
    }
}

