/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.EntitySpider;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.Vec3D;

public class EntityCaveSpider
extends EntitySpider {
    public EntityCaveSpider(EntityTypes<? extends EntityCaveSpider> var0, World var1) {
        super((EntityTypes<? extends EntitySpider>)var0, var1);
    }

    public static AttributeProvider.Builder createCaveSpider() {
        return EntitySpider.createAttributes().add(GenericAttributes.MAX_HEALTH, 12.0);
    }

    @Override
    public boolean doHurtTarget(WorldServer var0, Entity var1) {
        if (super.doHurtTarget(var0, var1)) {
            if (var1 instanceof EntityLiving) {
                int var2 = 0;
                if (this.level().getDifficulty() == EnumDifficulty.NORMAL) {
                    var2 = 7;
                } else if (this.level().getDifficulty() == EnumDifficulty.HARD) {
                    var2 = 15;
                }
                if (var2 > 0) {
                    ((EntityLiving)var1).addEffect(new MobEffect(MobEffects.POISON, var2 * 20, 0), this);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        return var3;
    }

    @Override
    public Vec3D getVehicleAttachmentPoint(Entity var0) {
        if (var0.getBbWidth() <= this.getBbWidth()) {
            return new Vec3D(0.0, 0.21875 * (double)this.getScale(), 0.0);
        }
        return super.getVehicleAttachmentPoint(var0);
    }
}

