/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;

public abstract class EntityProjectile
extends IProjectile {
    private static final float MIN_CAMERA_DISTANCE_SQUARED = 12.25f;

    protected EntityProjectile(EntityTypes<? extends EntityProjectile> var0, World var1) {
        super((EntityTypes<? extends IProjectile>)var0, var1);
    }

    protected EntityProjectile(EntityTypes<? extends EntityProjectile> var0, double var1, double var3, double var5, World var7) {
        this(var0, var7);
        this.setPos(var1, var3, var5);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        if (this.tickCount < 2 && var0 < 12.25) {
            return false;
        }
        double var2 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(var2)) {
            var2 = 4.0;
        }
        return var0 < (var2 *= 64.0) * var2;
    }

    @Override
    public boolean canUsePortal(boolean var0) {
        return true;
    }

    @Override
    public void tick() {
        this.handleFirstTickBubbleColumn();
        this.applyGravity();
        this.applyInertia();
        MovingObjectPosition var0 = ProjectileHelper.getHitResultOnMoveVector(this, this::canHitEntity);
        Vec3D var1 = var0.getType() != MovingObjectPosition.EnumMovingObjectType.MISS ? var0.getLocation() : this.position().add(this.getDeltaMovement());
        this.setPos(var1);
        this.updateRotation();
        this.applyEffectsFromBlocks();
        super.tick();
        if (var0.getType() != MovingObjectPosition.EnumMovingObjectType.MISS && this.isAlive()) {
            this.hitTargetOrDeflectSelf(var0);
        }
    }

    private void applyInertia() {
        float var2;
        Vec3D var0 = this.getDeltaMovement();
        Vec3D var1 = this.position();
        if (this.isInWater()) {
            for (int var3 = 0; var3 < 4; ++var3) {
                float var4 = 0.25f;
                this.level().addParticle(Particles.BUBBLE, var1.x - var0.x * 0.25, var1.y - var0.y * 0.25, var1.z - var0.z * 0.25, var0.x, var0.y, var0.z);
            }
            var2 = 0.8f;
        } else {
            var2 = 0.99f;
        }
        this.setDeltaMovement(var0.scale(var2));
    }

    private void handleFirstTickBubbleColumn() {
        if (this.firstTick) {
            for (BlockPosition var1 : BlockPosition.betweenClosed(this.getBoundingBox())) {
                IBlockData var2 = this.level().getBlockState(var1);
                if (!var2.is(Blocks.BUBBLE_COLUMN)) continue;
                var2.entityInside(this.level(), var1, this, InsideBlockEffectApplier.NOOP);
            }
        }
    }

    @Override
    protected double getDefaultGravity() {
        return 0.03;
    }
}

