/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public class EntityMinecartRideable
extends EntityMinecartAbstract {
    private float rotationOffset;
    private float playerRotationOffset;

    public EntityMinecartRideable(EntityTypes<?> var0, World var1) {
        super(var0, var1);
    }

    @Override
    public EnumInteractionResult interact(EntityHuman var0, EnumHand var1) {
        if (!var0.isSecondaryUseActive() && !this.isVehicle() && (this.level().isClientSide() || var0.startRiding(this))) {
            this.playerRotationOffset = this.rotationOffset;
            if (!this.level().isClientSide()) {
                return var0.startRiding(this) ? EnumInteractionResult.CONSUME : EnumInteractionResult.PASS;
            }
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    protected Item getDropItem() {
        return Items.MINECART;
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.MINECART);
    }

    @Override
    public void activateMinecart(int var0, int var1, int var2, boolean var3) {
        if (var3) {
            if (this.isVehicle()) {
                this.ejectPassengers();
            }
            if (this.getHurtTime() == 0) {
                this.setHurtDir(-this.getHurtDir());
                this.setHurtTime(10);
                this.setDamage(50.0f);
                this.markHurt();
            }
        }
    }

    @Override
    public boolean isRideable() {
        return true;
    }

    @Override
    public void tick() {
        double var0 = this.getYRot();
        Vec3D var2 = this.position();
        super.tick();
        double var3 = ((double)this.getYRot() - var0) % 360.0;
        if (this.level().isClientSide() && var2.distanceTo(this.position()) > 0.01) {
            this.rotationOffset += (float)var3;
            this.rotationOffset %= 360.0f;
        }
    }

    @Override
    protected void positionRider(Entity var0, Entity.MoveFunction var1) {
        EntityHuman var2;
        super.positionRider(var0, var1);
        if (this.level().isClientSide() && var0 instanceof EntityHuman && (var2 = (EntityHuman)var0).shouldRotateWithMinecart() && EntityMinecartRideable.useExperimentalMovement(this.level())) {
            float var3 = (float)MathHelper.rotLerp(0.5, (double)this.playerRotationOffset, (double)this.rotationOffset);
            var2.setYRot(var2.getYRot() - (var3 - this.playerRotationOffset));
            this.playerRotationOffset = var3;
        }
    }
}

