/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.BlockPoweredRail;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class OldMinecartBehavior
extends MinecartBehavior {
    private static final double MINECART_RIDABLE_THRESHOLD = 0.01;
    private static final double MAX_SPEED_IN_WATER = 0.2;
    private static final double MAX_SPEED_ON_LAND = 0.4;
    private static final double ABSOLUTE_MAX_SPEED = 0.4;
    private final InterpolationHandler interpolation;
    private Vec3D targetDeltaMovement = Vec3D.ZERO;

    public OldMinecartBehavior(EntityMinecartAbstract var0) {
        super(var0);
        this.interpolation = new InterpolationHandler((Entity)var0, this::onInterpolation);
    }

    @Override
    public InterpolationHandler getInterpolation() {
        return this.interpolation;
    }

    public void onInterpolation(InterpolationHandler var0) {
        this.setDeltaMovement(this.targetDeltaMovement);
    }

    @Override
    public void lerpMotion(Vec3D var0) {
        this.targetDeltaMovement = var0;
        this.setDeltaMovement(this.targetDeltaMovement);
    }

    @Override
    public void tick() {
        double var8;
        World world = this.level();
        if (!(world instanceof WorldServer)) {
            if (this.interpolation.hasActiveInterpolation()) {
                this.interpolation.interpolate();
            } else {
                this.minecart.reapplyPosition();
                this.setXRot(this.getXRot() % 360.0f);
                this.setYRot(this.getYRot() % 360.0f);
            }
            return;
        }
        WorldServer var0 = (WorldServer)world;
        this.minecart.applyGravity();
        BlockPosition var1 = this.minecart.getCurrentBlockPosOrRailBelow();
        IBlockData var2 = this.level().getBlockState(var1);
        boolean var3 = BlockMinecartTrackAbstract.isRail(var2);
        this.minecart.setOnRails(var3);
        if (var3) {
            this.moveAlongTrack(var0);
            if (var2.is(Blocks.ACTIVATOR_RAIL)) {
                this.minecart.activateMinecart(var1.getX(), var1.getY(), var1.getZ(), var2.getValue(BlockPoweredRail.POWERED));
            }
        } else {
            this.minecart.comeOffTrack(var0);
        }
        this.minecart.applyEffectsFromBlocks();
        this.setXRot(0.0f);
        double var4 = this.minecart.xo - this.getX();
        double var6 = this.minecart.zo - this.getZ();
        if (var4 * var4 + var6 * var6 > 0.001) {
            this.setYRot((float)(MathHelper.atan2(var6, var4) * 180.0 / Math.PI));
            if (this.minecart.isFlipped()) {
                this.setYRot(this.getYRot() + 180.0f);
            }
        }
        if ((var8 = (double)MathHelper.wrapDegrees(this.getYRot() - this.minecart.yRotO)) < -170.0 || var8 >= 170.0) {
            this.setYRot(this.getYRot() + 180.0f);
            this.minecart.setFlipped(!this.minecart.isFlipped());
        }
        this.setXRot(this.getXRot() % 360.0f);
        this.setYRot(this.getYRot() % 360.0f);
        this.pushAndPickupEntities();
    }

    @Override
    public void moveAlongTrack(WorldServer var0) {
        double var49;
        Vec3D var48;
        double var43;
        double var41;
        double var39;
        Vec3D var30;
        Object var31;
        BlockPosition var1 = this.minecart.getCurrentBlockPosOrRailBelow();
        IBlockData var2 = this.level().getBlockState(var1);
        this.minecart.resetFallDistance();
        double var3 = this.minecart.getX();
        double var5 = this.minecart.getY();
        double var7 = this.minecart.getZ();
        Vec3D var9 = this.getPos(var3, var5, var7);
        var5 = var1.getY();
        boolean var10 = false;
        boolean var11 = false;
        if (var2.is(Blocks.POWERED_RAIL)) {
            var10 = var2.getValue(BlockPoweredRail.POWERED);
            var11 = !var10;
        }
        double var12 = 0.0078125;
        if (this.minecart.isInWater()) {
            var12 *= 0.2;
        }
        Vec3D var14 = this.getDeltaMovement();
        BlockPropertyTrackPosition var15 = var2.getValue(((BlockMinecartTrackAbstract)var2.getBlock()).getShapeProperty());
        switch (var15) {
            case ASCENDING_EAST: {
                this.setDeltaMovement(var14.add(-var12, 0.0, 0.0));
                var5 += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.setDeltaMovement(var14.add(var12, 0.0, 0.0));
                var5 += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                this.setDeltaMovement(var14.add(0.0, 0.0, var12));
                var5 += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.setDeltaMovement(var14.add(0.0, 0.0, -var12));
                var5 += 1.0;
            }
        }
        var14 = this.getDeltaMovement();
        Pair<BaseBlockPosition, BaseBlockPosition> var16 = EntityMinecartAbstract.exits(var15);
        BaseBlockPosition var17 = (BaseBlockPosition)var16.getFirst();
        BaseBlockPosition var18 = (BaseBlockPosition)var16.getSecond();
        double var19 = var18.getX() - var17.getX();
        double var21 = var18.getZ() - var17.getZ();
        double var23 = Math.sqrt(var19 * var19 + var21 * var21);
        double var25 = var14.x * var19 + var14.z * var21;
        if (var25 < 0.0) {
            var19 = -var19;
            var21 = -var21;
        }
        double var27 = Math.min(2.0, var14.horizontalDistance());
        var14 = new Vec3D(var27 * var19 / var23, var14.y, var27 * var21 / var23);
        this.setDeltaMovement(var14);
        Entity var29 = this.minecart.getFirstPassenger();
        Entity entity = this.minecart.getFirstPassenger();
        if (entity instanceof EntityPlayer) {
            var31 = (EntityPlayer)entity;
            var30 = ((EntityPlayer)var31).getLastClientMoveIntent();
        } else {
            var30 = Vec3D.ZERO;
        }
        if (var29 instanceof EntityHuman && var30.lengthSqr() > 0.0) {
            var31 = var30.normalize();
            double var32 = this.getDeltaMovement().horizontalDistanceSqr();
            if (((Vec3D)var31).lengthSqr() > 0.0 && var32 < 0.01) {
                this.setDeltaMovement(this.getDeltaMovement().add(var30.x * 0.001, 0.0, var30.z * 0.001));
                var11 = false;
            }
        }
        if (var11) {
            double var312 = this.getDeltaMovement().horizontalDistance();
            if (var312 < 0.03) {
                this.setDeltaMovement(Vec3D.ZERO);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 0.0, 0.5));
            }
        }
        double var313 = (double)var1.getX() + 0.5 + (double)var17.getX() * 0.5;
        double var33 = (double)var1.getZ() + 0.5 + (double)var17.getZ() * 0.5;
        double var35 = (double)var1.getX() + 0.5 + (double)var18.getX() * 0.5;
        double var37 = (double)var1.getZ() + 0.5 + (double)var18.getZ() * 0.5;
        var19 = var35 - var313;
        var21 = var37 - var33;
        if (var19 == 0.0) {
            var39 = var7 - (double)var1.getZ();
        } else if (var21 == 0.0) {
            var39 = var3 - (double)var1.getX();
        } else {
            var41 = var3 - var313;
            var43 = var7 - var33;
            var39 = (var41 * var19 + var43 * var21) * 2.0;
        }
        var3 = var313 + var19 * var39;
        var7 = var33 + var21 * var39;
        this.setPos(var3, var5, var7);
        var41 = this.minecart.isVehicle() ? 0.75 : 1.0;
        var43 = this.minecart.getMaxSpeed(var0);
        var14 = this.getDeltaMovement();
        this.minecart.move(EnumMoveType.SELF, new Vec3D(MathHelper.clamp(var41 * var14.x, -var43, var43), 0.0, MathHelper.clamp(var41 * var14.z, -var43, var43)));
        if (var17.getY() != 0 && MathHelper.floor(this.minecart.getX()) - var1.getX() == var17.getX() && MathHelper.floor(this.minecart.getZ()) - var1.getZ() == var17.getZ()) {
            this.setPos(this.minecart.getX(), this.minecart.getY() + (double)var17.getY(), this.minecart.getZ());
        } else if (var18.getY() != 0 && MathHelper.floor(this.minecart.getX()) - var1.getX() == var18.getX() && MathHelper.floor(this.minecart.getZ()) - var1.getZ() == var18.getZ()) {
            this.setPos(this.minecart.getX(), this.minecart.getY() + (double)var18.getY(), this.minecart.getZ());
        }
        this.setDeltaMovement(this.minecart.applyNaturalSlowdown(this.getDeltaMovement()));
        Vec3D var45 = this.getPos(this.minecart.getX(), this.minecart.getY(), this.minecart.getZ());
        if (var45 != null && var9 != null) {
            double var46 = (var9.y - var45.y) * 0.05;
            var48 = this.getDeltaMovement();
            var49 = var48.horizontalDistance();
            if (var49 > 0.0) {
                this.setDeltaMovement(var48.multiply((var49 + var46) / var49, 1.0, (var49 + var46) / var49));
            }
            this.setPos(this.minecart.getX(), var45.y, this.minecart.getZ());
        }
        int var46 = MathHelper.floor(this.minecart.getX());
        int var47 = MathHelper.floor(this.minecart.getZ());
        if (var46 != var1.getX() || var47 != var1.getZ()) {
            var48 = this.getDeltaMovement();
            var49 = var48.horizontalDistance();
            this.setDeltaMovement(var49 * (double)(var46 - var1.getX()), var48.y, var49 * (double)(var47 - var1.getZ()));
        }
        if (var10) {
            var48 = this.getDeltaMovement();
            var49 = var48.horizontalDistance();
            if (var49 > 0.01) {
                double var51 = 0.06;
                this.setDeltaMovement(var48.add(var48.x / var49 * 0.06, 0.0, var48.z / var49 * 0.06));
            } else {
                Vec3D var51 = this.getDeltaMovement();
                double var52 = var51.x;
                double var54 = var51.z;
                if (var15 == BlockPropertyTrackPosition.EAST_WEST) {
                    if (this.minecart.isRedstoneConductor(var1.west())) {
                        var52 = 0.02;
                    } else if (this.minecart.isRedstoneConductor(var1.east())) {
                        var52 = -0.02;
                    }
                } else if (var15 == BlockPropertyTrackPosition.NORTH_SOUTH) {
                    if (this.minecart.isRedstoneConductor(var1.north())) {
                        var54 = 0.02;
                    } else if (this.minecart.isRedstoneConductor(var1.south())) {
                        var54 = -0.02;
                    }
                } else {
                    return;
                }
                this.setDeltaMovement(var52, var51.y, var54);
            }
        }
    }

    @Nullable
    public Vec3D getPosOffs(double var0, double var2, double var4, double var6) {
        IBlockData var11;
        int var8 = MathHelper.floor(var0);
        int var9 = MathHelper.floor(var2);
        int var10 = MathHelper.floor(var4);
        if (this.level().getBlockState(new BlockPosition(var8, var9 - 1, var10)).is(TagsBlock.RAILS)) {
            --var9;
        }
        if (BlockMinecartTrackAbstract.isRail(var11 = this.level().getBlockState(new BlockPosition(var8, var9, var10)))) {
            BlockPropertyTrackPosition var12 = var11.getValue(((BlockMinecartTrackAbstract)var11.getBlock()).getShapeProperty());
            var2 = var9;
            if (var12.isSlope()) {
                var2 = var9 + 1;
            }
            Pair<BaseBlockPosition, BaseBlockPosition> var13 = EntityMinecartAbstract.exits(var12);
            BaseBlockPosition var14 = (BaseBlockPosition)var13.getFirst();
            BaseBlockPosition var15 = (BaseBlockPosition)var13.getSecond();
            double var16 = var15.getX() - var14.getX();
            double var18 = var15.getZ() - var14.getZ();
            double var20 = Math.sqrt(var16 * var16 + var18 * var18);
            if (var14.getY() != 0 && MathHelper.floor(var0 += (var16 /= var20) * var6) - var8 == var14.getX() && MathHelper.floor(var4 += (var18 /= var20) * var6) - var10 == var14.getZ()) {
                var2 += (double)var14.getY();
            } else if (var15.getY() != 0 && MathHelper.floor(var0) - var8 == var15.getX() && MathHelper.floor(var4) - var10 == var15.getZ()) {
                var2 += (double)var15.getY();
            }
            return this.getPos(var0, var2, var4);
        }
        return null;
    }

    @Nullable
    public Vec3D getPos(double var0, double var2, double var4) {
        IBlockData var9;
        int var6 = MathHelper.floor(var0);
        int var7 = MathHelper.floor(var2);
        int var8 = MathHelper.floor(var4);
        if (this.level().getBlockState(new BlockPosition(var6, var7 - 1, var8)).is(TagsBlock.RAILS)) {
            --var7;
        }
        if (BlockMinecartTrackAbstract.isRail(var9 = this.level().getBlockState(new BlockPosition(var6, var7, var8)))) {
            double var32;
            BlockPropertyTrackPosition var10 = var9.getValue(((BlockMinecartTrackAbstract)var9.getBlock()).getShapeProperty());
            Pair<BaseBlockPosition, BaseBlockPosition> var11 = EntityMinecartAbstract.exits(var10);
            BaseBlockPosition var12 = (BaseBlockPosition)var11.getFirst();
            BaseBlockPosition var13 = (BaseBlockPosition)var11.getSecond();
            double var14 = (double)var6 + 0.5 + (double)var12.getX() * 0.5;
            double var16 = (double)var7 + 0.0625 + (double)var12.getY() * 0.5;
            double var18 = (double)var8 + 0.5 + (double)var12.getZ() * 0.5;
            double var20 = (double)var6 + 0.5 + (double)var13.getX() * 0.5;
            double var22 = (double)var7 + 0.0625 + (double)var13.getY() * 0.5;
            double var24 = (double)var8 + 0.5 + (double)var13.getZ() * 0.5;
            double var26 = var20 - var14;
            double var28 = (var22 - var16) * 2.0;
            double var30 = var24 - var18;
            if (var26 == 0.0) {
                var32 = var4 - (double)var8;
            } else if (var30 == 0.0) {
                var32 = var0 - (double)var6;
            } else {
                double var34 = var0 - var14;
                double var36 = var4 - var18;
                var32 = (var34 * var26 + var36 * var30) * 2.0;
            }
            var0 = var14 + var26 * var32;
            var2 = var16 + var28 * var32;
            var4 = var18 + var30 * var32;
            if (var28 < 0.0) {
                var2 += 1.0;
            } else if (var28 > 0.0) {
                var2 += 0.5;
            }
            return new Vec3D(var0, var2, var4);
        }
        return null;
    }

    @Override
    public double stepAlongTrack(BlockPosition var0, BlockPropertyTrackPosition var1, double var2) {
        return 0.0;
    }

    @Override
    public boolean pushAndPickupEntities() {
        block4: {
            AxisAlignedBB var0;
            block3: {
                var0 = this.minecart.getBoundingBox().inflate(0.2f, 0.0, 0.2f);
                if (!this.minecart.isRideable() || !(this.getDeltaMovement().horizontalDistanceSqr() >= 0.01)) break block3;
                List<Entity> var1 = this.level().getEntities(this.minecart, var0, IEntitySelector.pushableBy(this.minecart));
                if (var1.isEmpty()) break block4;
                for (Entity var3 : var1) {
                    if (var3 instanceof EntityHuman || var3 instanceof EntityIronGolem || var3 instanceof EntityMinecartAbstract || this.minecart.isVehicle() || var3.isPassenger()) {
                        var3.push(this.minecart);
                        continue;
                    }
                    var3.startRiding(this.minecart);
                }
                break block4;
            }
            for (Entity var2 : this.level().getEntities(this.minecart, var0)) {
                if (this.minecart.hasPassenger(var2) || !var2.isPushable() || !(var2 instanceof EntityMinecartAbstract)) continue;
                var2.push(this.minecart);
            }
        }
        return false;
    }

    @Override
    public EnumDirection getMotionDirection() {
        return this.minecart.isFlipped() ? this.minecart.getDirection().getOpposite().getClockWise() : this.minecart.getDirection().getClockWise();
    }

    @Override
    public Vec3D getKnownMovement(Vec3D var0) {
        if (Double.isNaN(var0.x) || Double.isNaN(var0.y) || Double.isNaN(var0.z)) {
            return Vec3D.ZERO;
        }
        return new Vec3D(MathHelper.clamp(var0.x, -0.4, 0.4), var0.y, MathHelper.clamp(var0.z, -0.4, 0.4));
    }

    @Override
    public double getMaxSpeed(WorldServer var0) {
        return this.minecart.isInWater() ? 0.2 : 0.4;
    }

    @Override
    public double getSlowdownFactor() {
        return this.minecart.isVehicle() ? 0.997 : 0.96;
    }
}

