/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import net.minecraft.recipebook.AutoRecipe;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.inventory.ContainerProperties;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotFurnaceFuel;
import net.minecraft.world.inventory.SlotFurnaceResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.World;

public abstract class ContainerFurnace
extends ContainerRecipeBook {
    public static final int INGREDIENT_SLOT = 0;
    public static final int FUEL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    public static final int SLOT_COUNT = 3;
    public static final int DATA_COUNT = 4;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    final IInventory container;
    private final IContainerProperties data;
    protected final World level;
    private final Recipes<? extends RecipeCooking> recipeType;
    private final RecipePropertySet acceptedInputs;
    private final RecipeBookType recipeBookType;

    protected ContainerFurnace(Containers<?> var0, Recipes<? extends RecipeCooking> var1, ResourceKey<RecipePropertySet> var2, RecipeBookType var3, int var4, PlayerInventory var5) {
        this(var0, var1, var2, var3, var4, var5, new InventorySubcontainer(3), new ContainerProperties(4));
    }

    protected ContainerFurnace(Containers<?> var0, Recipes<? extends RecipeCooking> var1, ResourceKey<RecipePropertySet> var2, RecipeBookType var3, int var4, PlayerInventory var5, IInventory var6, IContainerProperties var7) {
        super(var0, var4);
        this.recipeType = var1;
        this.recipeBookType = var3;
        ContainerFurnace.checkContainerSize(var6, 3);
        ContainerFurnace.checkContainerDataCount(var7, 4);
        this.container = var6;
        this.data = var7;
        this.level = var5.player.level();
        this.acceptedInputs = this.level.recipeAccess().propertySet(var2);
        this.addSlot(new Slot(var6, 0, 56, 17));
        this.addSlot(new SlotFurnaceFuel(this, var6, 1, 56, 53));
        this.addSlot(new SlotFurnaceResult(var5.player, var6, 2, 116, 35));
        this.addStandardInventorySlots(var5, 8, 84);
        this.addDataSlots(var7);
    }

    @Override
    public void fillCraftSlotsStackedContents(StackedItemContents var0) {
        if (this.container instanceof AutoRecipeOutput) {
            ((AutoRecipeOutput)((Object)this.container)).fillStackedContents(var0);
        }
    }

    public Slot getResultSlot() {
        return (Slot)this.slots.get(2);
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return this.container.stillValid(var0);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            if (var1 == 2) {
                if (!this.moveItemStackTo(var4, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                var3.onQuickCraft(var4, var2);
            } else if (var1 == 1 || var1 == 0 ? !this.moveItemStackTo(var4, 3, 39, false) : (this.canSmelt(var4) ? !this.moveItemStackTo(var4, 0, 1, false) : (this.isFuel(var4) ? !this.moveItemStackTo(var4, 1, 2, false) : (var1 >= 3 && var1 < 30 ? !this.moveItemStackTo(var4, 30, 39, false) : var1 >= 30 && var1 < 39 && !this.moveItemStackTo(var4, 3, 30, false))))) {
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.setByPlayer(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
            if (var4.getCount() == var2.getCount()) {
                return ItemStack.EMPTY;
            }
            var3.onTake(var0, var4);
        }
        return var2;
    }

    protected boolean canSmelt(ItemStack var0) {
        return this.acceptedInputs.test(var0);
    }

    protected boolean isFuel(ItemStack var0) {
        return this.level.fuelValues().isFuel(var0);
    }

    public float getBurnProgress() {
        int var0 = this.data.get(2);
        int var1 = this.data.get(3);
        if (var1 == 0 || var0 == 0) {
            return 0.0f;
        }
        return MathHelper.clamp((float)var0 / (float)var1, 0.0f, 1.0f);
    }

    public float getLitProgress() {
        int var0 = this.data.get(1);
        if (var0 == 0) {
            var0 = 200;
        }
        return MathHelper.clamp((float)this.data.get(0) / (float)var0, 0.0f, 1.0f);
    }

    public boolean isLit() {
        return this.data.get(0) > 0;
    }

    @Override
    public RecipeBookType getRecipeBookType() {
        return this.recipeBookType;
    }

    @Override
    public ContainerRecipeBook.a handlePlacement(boolean var0, boolean var1, RecipeHolder<?> var2, final WorldServer var3, PlayerInventory var4) {
        final List<Slot> var5 = List.of(this.getSlot(0), this.getSlot(2));
        RecipeHolder<?> var6 = var2;
        return AutoRecipe.placeRecipe(new AutoRecipe.a<RecipeCooking>(){

            @Override
            public void fillCraftSlotsStackedContents(StackedItemContents var0) {
                ContainerFurnace.this.fillCraftSlotsStackedContents(var0);
            }

            @Override
            public void clearCraftingContent() {
                var5.forEach(var0 -> var0.set(ItemStack.EMPTY));
            }

            @Override
            public boolean recipeMatches(RecipeHolder<RecipeCooking> var0) {
                return var0.value().matches(new SingleRecipeInput(ContainerFurnace.this.container.getItem(0)), (World)var3);
            }
        }, 1, 1, List.of(this.getSlot(0)), var5, var4, var6, var0, var1);
    }
}

