/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockRotatable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemAxe
extends Item {
    protected static final Map<Block, Block> STRIPPABLES = new ImmutableMap.Builder().put((Object)Blocks.OAK_WOOD, (Object)Blocks.STRIPPED_OAK_WOOD).put((Object)Blocks.OAK_LOG, (Object)Blocks.STRIPPED_OAK_LOG).put((Object)Blocks.DARK_OAK_WOOD, (Object)Blocks.STRIPPED_DARK_OAK_WOOD).put((Object)Blocks.DARK_OAK_LOG, (Object)Blocks.STRIPPED_DARK_OAK_LOG).put((Object)Blocks.PALE_OAK_WOOD, (Object)Blocks.STRIPPED_PALE_OAK_WOOD).put((Object)Blocks.PALE_OAK_LOG, (Object)Blocks.STRIPPED_PALE_OAK_LOG).put((Object)Blocks.ACACIA_WOOD, (Object)Blocks.STRIPPED_ACACIA_WOOD).put((Object)Blocks.ACACIA_LOG, (Object)Blocks.STRIPPED_ACACIA_LOG).put((Object)Blocks.CHERRY_WOOD, (Object)Blocks.STRIPPED_CHERRY_WOOD).put((Object)Blocks.CHERRY_LOG, (Object)Blocks.STRIPPED_CHERRY_LOG).put((Object)Blocks.BIRCH_WOOD, (Object)Blocks.STRIPPED_BIRCH_WOOD).put((Object)Blocks.BIRCH_LOG, (Object)Blocks.STRIPPED_BIRCH_LOG).put((Object)Blocks.JUNGLE_WOOD, (Object)Blocks.STRIPPED_JUNGLE_WOOD).put((Object)Blocks.JUNGLE_LOG, (Object)Blocks.STRIPPED_JUNGLE_LOG).put((Object)Blocks.SPRUCE_WOOD, (Object)Blocks.STRIPPED_SPRUCE_WOOD).put((Object)Blocks.SPRUCE_LOG, (Object)Blocks.STRIPPED_SPRUCE_LOG).put((Object)Blocks.WARPED_STEM, (Object)Blocks.STRIPPED_WARPED_STEM).put((Object)Blocks.WARPED_HYPHAE, (Object)Blocks.STRIPPED_WARPED_HYPHAE).put((Object)Blocks.CRIMSON_STEM, (Object)Blocks.STRIPPED_CRIMSON_STEM).put((Object)Blocks.CRIMSON_HYPHAE, (Object)Blocks.STRIPPED_CRIMSON_HYPHAE).put((Object)Blocks.MANGROVE_WOOD, (Object)Blocks.STRIPPED_MANGROVE_WOOD).put((Object)Blocks.MANGROVE_LOG, (Object)Blocks.STRIPPED_MANGROVE_LOG).put((Object)Blocks.BAMBOO_BLOCK, (Object)Blocks.STRIPPED_BAMBOO_BLOCK).build();

    public ItemAxe(ToolMaterial var0, float var1, float var2, Item.Info var3) {
        super(var3.axe(var0, var1, var2));
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        EntityHuman var3 = var0.getPlayer();
        if (ItemAxe.playerHasBlockingItemUseIntent(var0)) {
            return EnumInteractionResult.PASS;
        }
        Optional<IBlockData> var4 = this.evaluateNewBlockState(var1, var2, var3, var1.getBlockState(var2));
        if (var4.isEmpty()) {
            return EnumInteractionResult.PASS;
        }
        ItemStack var5 = var0.getItemInHand();
        if (var3 instanceof EntityPlayer) {
            CriterionTriggers.ITEM_USED_ON_BLOCK.trigger((EntityPlayer)var3, var2, var5);
        }
        var1.setBlock(var2, var4.get(), 11);
        var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var3, var4.get()));
        if (var3 != null) {
            var5.hurtAndBreak(1, (EntityLiving)var3, var0.getHand().asEquipmentSlot());
        }
        return EnumInteractionResult.SUCCESS;
    }

    private static boolean playerHasBlockingItemUseIntent(ItemActionContext var0) {
        EntityHuman var1 = var0.getPlayer();
        return var0.getHand().equals((Object)EnumHand.MAIN_HAND) && var1.getOffhandItem().has(DataComponents.BLOCKS_ATTACKS) && !var1.isSecondaryUseActive();
    }

    private Optional<IBlockData> evaluateNewBlockState(World var0, BlockPosition var12, @Nullable EntityHuman var2, IBlockData var3) {
        Optional<IBlockData> var4 = this.getStripped(var3);
        if (var4.isPresent()) {
            var0.playSound((Entity)var2, var12, SoundEffects.AXE_STRIP, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return var4;
        }
        Optional<IBlockData> var5 = WeatheringCopper.getPrevious(var3);
        if (var5.isPresent()) {
            ItemAxe.spawnSoundAndParticle(var0, var12, var2, var3, SoundEffects.AXE_SCRAPE, 3005);
            return var5;
        }
        Optional<IBlockData> var6 = Optional.ofNullable((Block)HoneycombItem.WAX_OFF_BY_BLOCK.get().get((Object)var3.getBlock())).map(var1 -> var1.withPropertiesOf(var3));
        if (var6.isPresent()) {
            ItemAxe.spawnSoundAndParticle(var0, var12, var2, var3, SoundEffects.AXE_WAX_OFF, 3004);
            return var6;
        }
        return Optional.empty();
    }

    private static void spawnSoundAndParticle(World var0, BlockPosition var1, @Nullable EntityHuman var2, IBlockData var3, SoundEffect var4, int var5) {
        var0.playSound((Entity)var2, var1, var4, SoundCategory.BLOCKS, 1.0f, 1.0f);
        var0.levelEvent(var2, var5, var1, 0);
        if (var3.getBlock() instanceof BlockChest && var3.getValue(BlockChest.TYPE) != BlockPropertyChestType.SINGLE) {
            BlockPosition var6 = BlockChest.getConnectedBlockPos(var1, var3);
            var0.gameEvent(GameEvent.BLOCK_CHANGE, var6, GameEvent.a.of(var2, var0.getBlockState(var6)));
            var0.levelEvent(var2, var5, var6, 0);
        }
    }

    private Optional<IBlockData> getStripped(IBlockData var0) {
        return Optional.ofNullable(STRIPPABLES.get(var0.getBlock())).map(var1 -> (IBlockData)var1.defaultBlockState().setValue(BlockRotatable.AXIS, var0.getValue(BlockRotatable.AXIS)));
    }
}

