/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.World;

public class ItemExpBottle
extends Item
implements ProjectileItem {
    public ItemExpBottle(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        var0.playSound(null, var1.getX(), var1.getY(), var1.getZ(), SoundEffects.EXPERIENCE_BOTTLE_THROW, SoundCategory.NEUTRAL, 0.5f, 0.4f / (var0.getRandom().nextFloat() * 0.4f + 0.8f));
        if (var0 instanceof WorldServer) {
            WorldServer var4 = (WorldServer)var0;
            IProjectile.spawnProjectileFromRotation(EntityThrownExpBottle::new, var4, var3, var1, -20.0f, 0.7f, 1.0f);
        }
        var1.awardStat(StatisticList.ITEM_USED.get(this));
        var3.consume(1, var1);
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    public IProjectile asProjectile(World var0, IPosition var1, ItemStack var2, EnumDirection var3) {
        return new EntityThrownExpBottle(var0, var1.x(), var1.y(), var1.z(), var2);
    }

    @Override
    public ProjectileItem.a createDispenseConfig() {
        return ProjectileItem.a.builder().uncertainty(ProjectileItem.a.DEFAULT.uncertainty() * 0.5f).power(ProjectileItem.a.DEFAULT.power() * 1.25f).build();
    }
}

