/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemFishingRod
extends Item {
    public ItemFishingRod(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        if (var1.fishing != null) {
            if (!var0.isClientSide()) {
                int var4 = var1.fishing.retrieve(var3);
                var3.hurtAndBreak(var4, (EntityLiving)var1, var2.asEquipmentSlot());
            }
            var0.playSound(null, var1.getX(), var1.getY(), var1.getZ(), SoundEffects.FISHING_BOBBER_RETRIEVE, SoundCategory.NEUTRAL, 1.0f, 0.4f / (var0.getRandom().nextFloat() * 0.4f + 0.8f));
            var1.gameEvent(GameEvent.ITEM_INTERACT_FINISH);
        } else {
            var0.playSound(null, var1.getX(), var1.getY(), var1.getZ(), SoundEffects.FISHING_BOBBER_THROW, SoundCategory.NEUTRAL, 0.5f, 0.4f / (var0.getRandom().nextFloat() * 0.4f + 0.8f));
            if (var0 instanceof WorldServer) {
                WorldServer var4 = (WorldServer)var0;
                int var5 = (int)(EnchantmentManager.getFishingTimeReduction(var4, var3, var1) * 20.0f);
                int var6 = EnchantmentManager.getFishingLuckBonus(var4, var3, var1);
                IProjectile.spawnProjectile(new EntityFishingHook(var1, var0, var6, var5), var4, var3);
            }
            var1.awardStat(StatisticList.ITEM_USED.get(this));
            var1.gameEvent(GameEvent.ITEM_INTERACT_START);
        }
        return EnumInteractionResult.SUCCESS;
    }
}

