/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemFlintAndSteel
extends Item {
    public ItemFlintAndSteel(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        BlockPosition var3;
        EntityHuman var1 = var0.getPlayer();
        World var2 = var0.getLevel();
        IBlockData var4 = var2.getBlockState(var3 = var0.getClickedPos());
        if (BlockCampfire.canLight(var4) || CandleBlock.canLight(var4) || CandleCakeBlock.canLight(var4)) {
            var2.playSound((Entity)var1, var3, SoundEffects.FLINTANDSTEEL_USE, SoundCategory.BLOCKS, 1.0f, var2.getRandom().nextFloat() * 0.4f + 0.8f);
            var2.setBlock(var3, (IBlockData)var4.setValue(BlockProperties.LIT, true), 11);
            var2.gameEvent((Entity)var1, GameEvent.BLOCK_CHANGE, var3);
            if (var1 != null) {
                var0.getItemInHand().hurtAndBreak(1, (EntityLiving)var1, var0.getHand().asEquipmentSlot());
            }
            return EnumInteractionResult.SUCCESS;
        }
        BlockPosition var5 = var3.relative(var0.getClickedFace());
        if (BlockFireAbstract.canBePlacedAt(var2, var5, var0.getHorizontalDirection())) {
            var2.playSound((Entity)var1, var5, SoundEffects.FLINTANDSTEEL_USE, SoundCategory.BLOCKS, 1.0f, var2.getRandom().nextFloat() * 0.4f + 0.8f);
            IBlockData var6 = BlockFireAbstract.getState(var2, var5);
            var2.setBlock(var5, var6, 11);
            var2.gameEvent((Entity)var1, GameEvent.BLOCK_PLACE, var3);
            ItemStack var7 = var0.getItemInHand();
            if (var1 instanceof EntityPlayer) {
                CriterionTriggers.PLACED_BLOCK.trigger((EntityPlayer)var1, var5, var7);
                var7.hurtAndBreak(1, (EntityLiving)var1, var0.getHand().asEquipmentSlot());
            }
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.FAIL;
    }
}

