/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;

public record BlocksAttacks(float blockDelaySeconds, float disableCooldownScale, List<a> damageReductions, b itemDamage, Optional<TagKey<DamageType>> bypassedBy, Optional<Holder<SoundEffect>> blockSound, Optional<Holder<SoundEffect>> disableSound) {
    public static final Codec<BlocksAttacks> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.NON_NEGATIVE_FLOAT.optionalFieldOf("block_delay_seconds", (Object)Float.valueOf(0.0f)).forGetter(BlocksAttacks::blockDelaySeconds), (App)ExtraCodecs.NON_NEGATIVE_FLOAT.optionalFieldOf("disable_cooldown_scale", (Object)Float.valueOf(1.0f)).forGetter(BlocksAttacks::disableCooldownScale), (App)a.CODEC.listOf().optionalFieldOf("damage_reductions", List.of(new a(90.0f, Optional.empty(), 0.0f, 1.0f))).forGetter(BlocksAttacks::damageReductions), (App)b.CODEC.optionalFieldOf("item_damage", (Object)b.DEFAULT).forGetter(BlocksAttacks::itemDamage), (App)TagKey.hashedCodec(Registries.DAMAGE_TYPE).optionalFieldOf("bypassed_by").forGetter(BlocksAttacks::bypassedBy), (App)SoundEffect.CODEC.optionalFieldOf("block_sound").forGetter(BlocksAttacks::blockSound), (App)SoundEffect.CODEC.optionalFieldOf("disabled_sound").forGetter(BlocksAttacks::disableSound)).apply((Applicative)var0, BlocksAttacks::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BlocksAttacks> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.FLOAT, BlocksAttacks::blockDelaySeconds, ByteBufCodecs.FLOAT, BlocksAttacks::disableCooldownScale, a.STREAM_CODEC.apply(ByteBufCodecs.list()), BlocksAttacks::damageReductions, b.STREAM_CODEC, BlocksAttacks::itemDamage, TagKey.streamCodec(Registries.DAMAGE_TYPE).apply(ByteBufCodecs::optional), BlocksAttacks::bypassedBy, SoundEffect.STREAM_CODEC.apply(ByteBufCodecs::optional), BlocksAttacks::blockSound, SoundEffect.STREAM_CODEC.apply(ByteBufCodecs::optional), BlocksAttacks::disableSound, BlocksAttacks::new);

    public void onBlocked(WorldServer var0, EntityLiving var1) {
        this.blockSound.ifPresent(var2 -> var0.playSound(null, var1.getX(), var1.getY(), var1.getZ(), (Holder<SoundEffect>)var2, var1.getSoundSource(), 1.0f, 0.8f + var0.random.nextFloat() * 0.4f));
    }

    public void disable(WorldServer var0, EntityLiving var1, float var22, ItemStack var3) {
        int var4 = this.disableBlockingForTicks(var22);
        if (var4 > 0) {
            if (var1 instanceof EntityHuman) {
                EntityHuman var5 = (EntityHuman)var1;
                var5.getCooldowns().addCooldown(var3, var4);
            }
            var1.stopUsingItem();
            this.disableSound.ifPresent(var2 -> var0.playSound(null, var1.getX(), var1.getY(), var1.getZ(), (Holder<SoundEffect>)var2, var1.getSoundSource(), 0.8f, 0.8f + var0.random.nextFloat() * 0.4f));
        }
    }

    public void hurtBlockingItem(World var0, ItemStack var1, EntityLiving var2, EnumHand var3, float var4) {
        int var6;
        if (!(var2 instanceof EntityHuman)) {
            return;
        }
        EntityHuman var5 = (EntityHuman)var2;
        if (!var0.isClientSide()) {
            var5.awardStat(StatisticList.ITEM_USED.get(var1.getItem()));
        }
        if ((var6 = this.itemDamage.apply(var4)) > 0) {
            var1.hurtAndBreak(var6, var2, var3.asEquipmentSlot());
        }
    }

    private int disableBlockingForTicks(float var0) {
        float var1 = var0 * this.disableCooldownScale;
        if (var1 > 0.0f) {
            return Math.round(var1 * 20.0f);
        }
        return 0;
    }

    public int blockDelayTicks() {
        return Math.round(this.blockDelaySeconds * 20.0f);
    }

    public float resolveBlockedDamage(DamageSource var0, float var1, double var2) {
        float var4 = 0.0f;
        for (a var6 : this.damageReductions) {
            var4 += var6.resolve(var0, var1, var2);
        }
        return MathHelper.clamp(var4, 0.0f, var1);
    }

    public record b(float threshold, float base, float factor) {
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.NON_NEGATIVE_FLOAT.fieldOf("threshold").forGetter(b::threshold), (App)Codec.FLOAT.fieldOf("base").forGetter(b::base), (App)Codec.FLOAT.fieldOf("factor").forGetter(b::factor)).apply((Applicative)var0, b::new));
        public static final StreamCodec<ByteBuf, b> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.FLOAT, b::threshold, ByteBufCodecs.FLOAT, b::base, ByteBufCodecs.FLOAT, b::factor, b::new);
        public static final b DEFAULT = new b(1.0f, 0.0f, 1.0f);

        public int apply(float var0) {
            if (var0 < this.threshold) {
                return 0;
            }
            return MathHelper.floor(this.base + this.factor * var0);
        }
    }

    public record a(float horizontalBlockingAngle, Optional<HolderSet<DamageType>> type, float base, float factor) {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("horizontal_blocking_angle", (Object)Float.valueOf(90.0f)).forGetter(a::horizontalBlockingAngle), (App)RegistryCodecs.homogeneousList(Registries.DAMAGE_TYPE).optionalFieldOf("type").forGetter(a::type), (App)Codec.FLOAT.fieldOf("base").forGetter(a::base), (App)Codec.FLOAT.fieldOf("factor").forGetter(a::factor)).apply((Applicative)var0, a::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, a> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.FLOAT, a::horizontalBlockingAngle, ByteBufCodecs.holderSet(Registries.DAMAGE_TYPE).apply(ByteBufCodecs::optional), a::type, ByteBufCodecs.FLOAT, a::base, ByteBufCodecs.FLOAT, a::factor, a::new);

        public float resolve(DamageSource var0, float var1, double var2) {
            if (var2 > (double)((float)Math.PI / 180 * this.horizontalBlockingAngle)) {
                return 0.0f;
            }
            if (this.type.isPresent() && !this.type.get().contains(var0.typeHolder())) {
                return 0.0f;
            }
            return MathHelper.clamp(this.base + this.factor * var1, 0.0f, var1);
        }
    }
}

