/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.Recipes;

public interface RecipeCrafting
extends IRecipe<CraftingInput> {
    @Override
    default public Recipes<RecipeCrafting> getType() {
        return Recipes.CRAFTING;
    }

    @Override
    public RecipeSerializer<? extends RecipeCrafting> getSerializer();

    public CraftingBookCategory category();

    default public NonNullList<ItemStack> getRemainingItems(CraftingInput var0) {
        return RecipeCrafting.defaultCraftingReminder(var0);
    }

    public static NonNullList<ItemStack> defaultCraftingReminder(CraftingInput var0) {
        NonNullList<ItemStack> var1 = NonNullList.withSize(var0.size(), ItemStack.EMPTY);
        for (int var2 = 0; var2 < var1.size(); ++var2) {
            Item var3 = var0.getItem(var2).getItem();
            var1.set(var2, var3.getCraftingRemainder());
        }
        return var1;
    }

    @Override
    default public RecipeBookCategory recipeBookCategory() {
        return switch (this.category()) {
            default -> throw new MatchException(null, null);
            case CraftingBookCategory.BUILDING -> RecipeBookCategories.CRAFTING_BUILDING_BLOCKS;
            case CraftingBookCategory.EQUIPMENT -> RecipeBookCategories.CRAFTING_EQUIPMENT;
            case CraftingBookCategory.REDSTONE -> RecipeBookCategories.CRAFTING_REDSTONE;
            case CraftingBookCategory.MISC -> RecipeBookCategories.CRAFTING_MISC;
        };
    }
}

