/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.TransmuteResult;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.World;

public class TransmuteRecipe
implements RecipeCrafting {
    final String group;
    final CraftingBookCategory category;
    final RecipeItemStack input;
    final RecipeItemStack material;
    final TransmuteResult result;
    @Nullable
    private PlacementInfo placementInfo;

    public TransmuteRecipe(String var0, CraftingBookCategory var1, RecipeItemStack var2, RecipeItemStack var3, TransmuteResult var4) {
        this.group = var0;
        this.category = var1;
        this.input = var2;
        this.material = var3;
        this.result = var4;
    }

    @Override
    public boolean matches(CraftingInput var0, World var1) {
        if (var0.ingredientCount() != 2) {
            return false;
        }
        boolean var2 = false;
        boolean var3 = false;
        for (int var4 = 0; var4 < var0.size(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (!var2 && this.input.test(var5)) {
                if (this.result.isResultUnchanged(var5)) {
                    return false;
                }
                var2 = true;
                continue;
            }
            if (!var3 && this.material.test(var5)) {
                var3 = true;
                continue;
            }
            return false;
        }
        return var2 && var3;
    }

    @Override
    public ItemStack assemble(CraftingInput var0, HolderLookup.a var1) {
        for (int var2 = 0; var2 < var0.size(); ++var2) {
            ItemStack var3 = var0.getItem(var2);
            if (var3.isEmpty() || !this.input.test(var3)) continue;
            return this.result.apply(var3);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public List<RecipeDisplay> display() {
        return List.of(new ShapelessCraftingRecipeDisplay(List.of(this.input.display(), this.material.display()), this.result.display(), new SlotDisplay.d(Items.CRAFTING_TABLE)));
    }

    @Override
    public RecipeSerializer<TransmuteRecipe> getSerializer() {
        return RecipeSerializer.TRANSMUTE;
    }

    @Override
    public String group() {
        return this.group;
    }

    @Override
    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create(List.of(this.input, this.material));
        }
        return this.placementInfo;
    }

    @Override
    public CraftingBookCategory category() {
        return this.category;
    }

    public static class a
    implements RecipeSerializer<TransmuteRecipe> {
        private static final MapCodec<TransmuteRecipe> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(var0 -> var0.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(var0 -> var0.category), (App)RecipeItemStack.CODEC.fieldOf("input").forGetter(var0 -> var0.input), (App)RecipeItemStack.CODEC.fieldOf("material").forGetter(var0 -> var0.material), (App)TransmuteResult.CODEC.fieldOf("result").forGetter(var0 -> var0.result)).apply((Applicative)var02, TransmuteRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, TransmuteRecipe> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.STRING_UTF8, var0 -> var0.group, CraftingBookCategory.STREAM_CODEC, var0 -> var0.category, RecipeItemStack.CONTENTS_STREAM_CODEC, var0 -> var0.input, RecipeItemStack.CONTENTS_STREAM_CODEC, var0 -> var0.material, TransmuteResult.STREAM_CODEC, var0 -> var0.result, TransmuteRecipe::new);

        @Override
        public MapCodec<TransmuteRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, TransmuteRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

