/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.display.SlotDisplay;

public record TransmuteResult(Holder<Item> item, int count, DataComponentPatch components) {
    private static final Codec<TransmuteResult> FULL_CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Item.CODEC.fieldOf("id").forGetter(TransmuteResult::item), (App)ExtraCodecs.intRange(1, 99).optionalFieldOf("count", (Object)1).forGetter(TransmuteResult::count), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(TransmuteResult::components)).apply((Applicative)var0, TransmuteResult::new));
    public static final Codec<TransmuteResult> CODEC = Codec.withAlternative(FULL_CODEC, Item.CODEC, var0 -> new TransmuteResult((Item)var0.value())).validate(TransmuteResult::validate);
    public static final StreamCodec<RegistryFriendlyByteBuf, TransmuteResult> STREAM_CODEC = StreamCodec.composite(Item.STREAM_CODEC, TransmuteResult::item, ByteBufCodecs.VAR_INT, TransmuteResult::count, DataComponentPatch.STREAM_CODEC, TransmuteResult::components, TransmuteResult::new);

    public TransmuteResult(Item var0) {
        this(var0.builtInRegistryHolder(), 1, DataComponentPatch.EMPTY);
    }

    private static DataResult<TransmuteResult> validate(TransmuteResult var0) {
        return ItemStack.validateStrict(new ItemStack(var0.item, var0.count, var0.components)).map(var1 -> var0);
    }

    public ItemStack apply(ItemStack var0) {
        ItemStack var1 = var0.transmuteCopy(this.item.value(), this.count);
        var1.applyComponents(this.components);
        return var1;
    }

    public boolean isResultUnchanged(ItemStack var0) {
        ItemStack var1 = this.apply(var0);
        return var1.getCount() == 1 && ItemStack.isSameItemSameComponents(var0, var1);
    }

    public SlotDisplay display() {
        return new SlotDisplay.f(new ItemStack(this.item, this.count, this.components));
    }
}

