/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface IBlockAccess
extends LevelHeightAccessor {
    @Nullable
    public TileEntity getBlockEntity(BlockPosition var1);

    default public <T extends TileEntity> Optional<T> getBlockEntity(BlockPosition var0, TileEntityTypes<T> var1) {
        TileEntity var2 = this.getBlockEntity(var0);
        if (var2 == null || var2.getType() != var1) {
            return Optional.empty();
        }
        return Optional.of(var2);
    }

    public IBlockData getBlockState(BlockPosition var1);

    public Fluid getFluidState(BlockPosition var1);

    default public int getLightEmission(BlockPosition var0) {
        return this.getBlockState(var0).getLightEmission();
    }

    default public Stream<IBlockData> getBlockStates(AxisAlignedBB var0) {
        return BlockPosition.betweenClosedStream(var0).map(this::getBlockState);
    }

    default public MovingObjectPositionBlock isBlockInLine(ClipBlockStateContext var02) {
        return IBlockAccess.traverseBlocks(var02.getFrom(), var02.getTo(), var02, (var0, var1) -> {
            IBlockData var2 = this.getBlockState((BlockPosition)var1);
            Vec3D var3 = var0.getFrom().subtract(var0.getTo());
            return var0.isTargetBlock().test(var2) ? new MovingObjectPositionBlock(var0.getTo(), EnumDirection.getApproximateNearest(var3.x, var3.y, var3.z), BlockPosition.containing(var0.getTo()), false) : null;
        }, var0 -> {
            Vec3D var1 = var0.getFrom().subtract(var0.getTo());
            return MovingObjectPositionBlock.miss(var0.getTo(), EnumDirection.getApproximateNearest(var1.x, var1.y, var1.z), BlockPosition.containing(var0.getTo()));
        });
    }

    default public MovingObjectPositionBlock clip(RayTrace var02) {
        return IBlockAccess.traverseBlocks(var02.getFrom(), var02.getTo(), var02, (var0, var1) -> {
            IBlockData var2 = this.getBlockState((BlockPosition)var1);
            Fluid var3 = this.getFluidState((BlockPosition)var1);
            Vec3D var4 = var0.getFrom();
            Vec3D var5 = var0.getTo();
            VoxelShape var6 = var0.getBlockShape(var2, this, (BlockPosition)var1);
            MovingObjectPositionBlock var7 = this.clipWithInteractionOverride(var4, var5, (BlockPosition)var1, var6, var2);
            VoxelShape var8 = var0.getFluidShape(var3, this, (BlockPosition)var1);
            MovingObjectPositionBlock var9 = var8.clip(var4, var5, (BlockPosition)var1);
            double var10 = var7 == null ? Double.MAX_VALUE : var0.getFrom().distanceToSqr(var7.getLocation());
            double var12 = var9 == null ? Double.MAX_VALUE : var0.getFrom().distanceToSqr(var9.getLocation());
            return var10 <= var12 ? var7 : var9;
        }, var0 -> {
            Vec3D var1 = var0.getFrom().subtract(var0.getTo());
            return MovingObjectPositionBlock.miss(var0.getTo(), EnumDirection.getApproximateNearest(var1.x, var1.y, var1.z), BlockPosition.containing(var0.getTo()));
        });
    }

    @Nullable
    default public MovingObjectPositionBlock clipWithInteractionOverride(Vec3D var0, Vec3D var1, BlockPosition var2, VoxelShape var3, IBlockData var4) {
        MovingObjectPositionBlock var6;
        MovingObjectPositionBlock var5 = var3.clip(var0, var1, var2);
        if (var5 != null && (var6 = var4.getInteractionShape(this, var2).clip(var0, var1, var2)) != null && var6.getLocation().subtract(var0).lengthSqr() < var5.getLocation().subtract(var0).lengthSqr()) {
            return var5.withDirection(var6.getDirection());
        }
        return var5;
    }

    default public double getBlockFloorHeight(VoxelShape var0, Supplier<VoxelShape> var1) {
        if (!var0.isEmpty()) {
            return var0.max(EnumDirection.EnumAxis.Y);
        }
        double var2 = var1.get().max(EnumDirection.EnumAxis.Y);
        if (var2 >= 1.0) {
            return var2 - 1.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    default public double getBlockFloorHeight(BlockPosition var0) {
        return this.getBlockFloorHeight(this.getBlockState(var0).getCollisionShape(this, var0), () -> {
            BlockPosition var1 = var0.below();
            return this.getBlockState(var1).getCollisionShape(this, var1);
        });
    }

    public static <T, C> T traverseBlocks(Vec3D var0, Vec3D var1, C var2, BiFunction<C, BlockPosition, T> var3, Function<C, T> var4) {
        int var19;
        int var18;
        if (var0.equals(var1)) {
            return var4.apply(var2);
        }
        double var5 = MathHelper.lerp(-1.0E-7, var1.x, var0.x);
        double var7 = MathHelper.lerp(-1.0E-7, var1.y, var0.y);
        double var9 = MathHelper.lerp(-1.0E-7, var1.z, var0.z);
        double var11 = MathHelper.lerp(-1.0E-7, var0.x, var1.x);
        double var13 = MathHelper.lerp(-1.0E-7, var0.y, var1.y);
        double var15 = MathHelper.lerp(-1.0E-7, var0.z, var1.z);
        int var17 = MathHelper.floor(var11);
        BlockPosition.MutableBlockPosition var20 = new BlockPosition.MutableBlockPosition(var17, var18 = MathHelper.floor(var13), var19 = MathHelper.floor(var15));
        T var21 = var3.apply(var2, var20);
        if (var21 != null) {
            return var21;
        }
        double var22 = var5 - var11;
        double var24 = var7 - var13;
        double var26 = var9 - var15;
        int var28 = MathHelper.sign(var22);
        int var29 = MathHelper.sign(var24);
        int var30 = MathHelper.sign(var26);
        double var31 = var28 == 0 ? Double.MAX_VALUE : (double)var28 / var22;
        double var33 = var29 == 0 ? Double.MAX_VALUE : (double)var29 / var24;
        double var35 = var30 == 0 ? Double.MAX_VALUE : (double)var30 / var26;
        double var37 = var31 * (var28 > 0 ? 1.0 - MathHelper.frac(var11) : MathHelper.frac(var11));
        double var39 = var33 * (var29 > 0 ? 1.0 - MathHelper.frac(var13) : MathHelper.frac(var13));
        double var41 = var35 * (var30 > 0 ? 1.0 - MathHelper.frac(var15) : MathHelper.frac(var15));
        while (var37 <= 1.0 || var39 <= 1.0 || var41 <= 1.0) {
            T var43;
            if (var37 < var39) {
                if (var37 < var41) {
                    var17 += var28;
                    var37 += var31;
                } else {
                    var19 += var30;
                    var41 += var35;
                }
            } else if (var39 < var41) {
                var18 += var29;
                var39 += var33;
            } else {
                var19 += var30;
                var41 += var35;
            }
            if ((var43 = var3.apply(var2, var20.set(var17, var18, var19))) == null) continue;
            return var43;
        }
        return var4.apply(var2);
    }

    public static boolean forEachBlockIntersectedBetween(Vec3D var0, Vec3D var1, AxisAlignedBB var2, a var3) {
        Vec3D var4 = var1.subtract(var0);
        if (var4.lengthSqr() < (double)MathHelper.square(1.0E-5f)) {
            for (BlockPosition var6 : BlockPosition.betweenClosed(var2)) {
                if (var3.visit(var6, 0)) continue;
                return false;
            }
            return true;
        }
        LongOpenHashSet var5 = new LongOpenHashSet();
        for (BlockPosition var7 : BlockPosition.betweenCornersInDirection(var2.move(var4.scale(-1.0)), var4)) {
            if (!var3.visit(var7, 0)) {
                return false;
            }
            var5.add(var7.asLong());
        }
        int var6 = IBlockAccess.addCollisionsAlongTravel((LongSet)var5, var4, var2, var3);
        if (var6 < 0) {
            return false;
        }
        for (BlockPosition var8 : BlockPosition.betweenCornersInDirection(var2, var4)) {
            if (!var5.add(var8.asLong()) || var3.visit(var8, var6 + 1)) continue;
            return false;
        }
        return true;
    }

    private static int addCollisionsAlongTravel(LongSet var0, Vec3D var1, AxisAlignedBB var2, a var3) {
        double var4 = var2.getXsize();
        double var6 = var2.getYsize();
        double var8 = var2.getZsize();
        BaseBlockPosition var10 = IBlockAccess.getFurthestCorner(var1);
        Vec3D var11 = var2.getCenter();
        Vec3D var12 = new Vec3D(var11.x() + var4 * 0.5 * (double)var10.getX(), var11.y() + var6 * 0.5 * (double)var10.getY(), var11.z() + var8 * 0.5 * (double)var10.getZ());
        Vec3D var13 = var12.subtract(var1);
        int var14 = MathHelper.floor(var13.x);
        int var15 = MathHelper.floor(var13.y);
        int var16 = MathHelper.floor(var13.z);
        int var17 = MathHelper.sign(var1.x);
        int var18 = MathHelper.sign(var1.y);
        int var19 = MathHelper.sign(var1.z);
        double var20 = var17 == 0 ? Double.MAX_VALUE : (double)var17 / var1.x;
        double var22 = var18 == 0 ? Double.MAX_VALUE : (double)var18 / var1.y;
        double var24 = var19 == 0 ? Double.MAX_VALUE : (double)var19 / var1.z;
        double var26 = var20 * (var17 > 0 ? 1.0 - MathHelper.frac(var13.x) : MathHelper.frac(var13.x));
        double var28 = var22 * (var18 > 0 ? 1.0 - MathHelper.frac(var13.y) : MathHelper.frac(var13.y));
        double var30 = var24 * (var19 > 0 ? 1.0 - MathHelper.frac(var13.z) : MathHelper.frac(var13.z));
        int var32 = 0;
        while (var26 <= 1.0 || var28 <= 1.0 || var30 <= 1.0) {
            if (var26 < var28) {
                if (var26 < var30) {
                    var14 += var17;
                    var26 += var20;
                } else {
                    var16 += var19;
                    var30 += var24;
                }
            } else if (var28 < var30) {
                var15 += var18;
                var28 += var22;
            } else {
                var16 += var19;
                var30 += var24;
            }
            Optional<Vec3D> var33 = AxisAlignedBB.clip(var14, var15, var16, var14 + 1, var15 + 1, var16 + 1, var13, var12);
            if (var33.isEmpty()) continue;
            Vec3D var34 = var33.get();
            double var35 = MathHelper.clamp(var34.x, (double)var14 + (double)1.0E-5f, (double)var14 + 1.0 - (double)1.0E-5f);
            double var37 = MathHelper.clamp(var34.y, (double)var15 + (double)1.0E-5f, (double)var15 + 1.0 - (double)1.0E-5f);
            double var39 = MathHelper.clamp(var34.z, (double)var16 + (double)1.0E-5f, (double)var16 + 1.0 - (double)1.0E-5f);
            int var41 = MathHelper.floor(var35 - var4 * (double)var10.getX());
            int var42 = MathHelper.floor(var37 - var6 * (double)var10.getY());
            int var43 = MathHelper.floor(var39 - var8 * (double)var10.getZ());
            int var44 = ++var32;
            for (BlockPosition var46 : BlockPosition.betweenCornersInDirection(var14, var15, var16, var41, var42, var43, var1)) {
                if (!var0.add(var46.asLong()) || var3.visit(var46, var44)) continue;
                return -1;
            }
        }
        return var32;
    }

    private static BaseBlockPosition getFurthestCorner(Vec3D var0) {
        int var9;
        double var1 = Math.abs(Vec3D.X_AXIS.dot(var0));
        double var3 = Math.abs(Vec3D.Y_AXIS.dot(var0));
        double var5 = Math.abs(Vec3D.Z_AXIS.dot(var0));
        int var7 = var0.x >= 0.0 ? 1 : -1;
        int var8 = var0.y >= 0.0 ? 1 : -1;
        int n2 = var9 = var0.z >= 0.0 ? 1 : -1;
        if (var1 <= var3 && var1 <= var5) {
            return new BaseBlockPosition(-var7, -var9, var8);
        }
        if (var3 <= var5) {
            return new BaseBlockPosition(var9, -var8, -var7);
        }
        return new BaseBlockPosition(-var8, var7, -var9);
    }

    @FunctionalInterface
    public static interface a {
        public boolean visit(BlockPosition var1, int var2);
    }
}

