/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.BlockRedstoneWire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public interface SignalGetter
extends IBlockAccess {
    public static final EnumDirection[] DIRECTIONS = EnumDirection.values();

    default public int getDirectSignal(BlockPosition var0, EnumDirection var1) {
        return this.getBlockState(var0).getDirectSignal(this, var0, var1);
    }

    default public int getDirectSignalTo(BlockPosition var0) {
        int var1 = 0;
        if ((var1 = Math.max(var1, this.getDirectSignal(var0.below(), EnumDirection.DOWN))) >= 15) {
            return var1;
        }
        if ((var1 = Math.max(var1, this.getDirectSignal(var0.above(), EnumDirection.UP))) >= 15) {
            return var1;
        }
        if ((var1 = Math.max(var1, this.getDirectSignal(var0.north(), EnumDirection.NORTH))) >= 15) {
            return var1;
        }
        if ((var1 = Math.max(var1, this.getDirectSignal(var0.south(), EnumDirection.SOUTH))) >= 15) {
            return var1;
        }
        if ((var1 = Math.max(var1, this.getDirectSignal(var0.west(), EnumDirection.WEST))) >= 15) {
            return var1;
        }
        if ((var1 = Math.max(var1, this.getDirectSignal(var0.east(), EnumDirection.EAST))) >= 15) {
            return var1;
        }
        return var1;
    }

    default public int getControlInputSignal(BlockPosition var0, EnumDirection var1, boolean var2) {
        IBlockData var3 = this.getBlockState(var0);
        if (var2) {
            return BlockDiodeAbstract.isDiode(var3) ? this.getDirectSignal(var0, var1) : 0;
        }
        if (var3.is(Blocks.REDSTONE_BLOCK)) {
            return 15;
        }
        if (var3.is(Blocks.REDSTONE_WIRE)) {
            return var3.getValue(BlockRedstoneWire.POWER);
        }
        if (var3.isSignalSource()) {
            return this.getDirectSignal(var0, var1);
        }
        return 0;
    }

    default public boolean hasSignal(BlockPosition var0, EnumDirection var1) {
        return this.getSignal(var0, var1) > 0;
    }

    default public int getSignal(BlockPosition var0, EnumDirection var1) {
        IBlockData var2 = this.getBlockState(var0);
        int var3 = var2.getSignal(this, var0, var1);
        if (var2.isRedstoneConductor(this, var0)) {
            return Math.max(var3, this.getDirectSignalTo(var0));
        }
        return var3;
    }

    default public boolean hasNeighborSignal(BlockPosition var0) {
        if (this.getSignal(var0.below(), EnumDirection.DOWN) > 0) {
            return true;
        }
        if (this.getSignal(var0.above(), EnumDirection.UP) > 0) {
            return true;
        }
        if (this.getSignal(var0.north(), EnumDirection.NORTH) > 0) {
            return true;
        }
        if (this.getSignal(var0.south(), EnumDirection.SOUTH) > 0) {
            return true;
        }
        if (this.getSignal(var0.west(), EnumDirection.WEST) > 0) {
            return true;
        }
        return this.getSignal(var0.east(), EnumDirection.EAST) > 0;
    }

    default public int getBestNeighborSignal(BlockPosition var0) {
        int var1 = 0;
        for (EnumDirection var5 : DIRECTIONS) {
            int var6 = this.getSignal(var0.relative(var5), var5);
            if (var6 >= 15) {
                return 15;
            }
            if (var6 <= var1) continue;
            var1 = var6;
        }
        return var1;
    }
}

