/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSoil;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockCrops
extends VegetationBlock
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockCrops> CODEC = BlockCrops.simpleCodec(BlockCrops::new);
    public static final int MAX_AGE = 7;
    public static final BlockStateInteger AGE = BlockProperties.AGE_7;
    private static final VoxelShape[] SHAPES = Block.boxes(7, var0 -> Block.column(16.0, 0.0, 2 + var0 * 2));

    public MapCodec<? extends BlockCrops> codec() {
        return CODEC;
    }

    protected BlockCrops(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(this.getAgeProperty(), 0));
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPES[this.getAge(var0)];
    }

    @Override
    protected boolean mayPlaceOn(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return var0.is(Blocks.FARMLAND);
    }

    protected BlockStateInteger getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    public int getAge(IBlockData var0) {
        return var0.getValue(this.getAgeProperty());
    }

    public IBlockData getStateForAge(int var0) {
        return (IBlockData)this.defaultBlockState().setValue(this.getAgeProperty(), var0);
    }

    public final boolean isMaxAge(IBlockData var0) {
        return this.getAge(var0) >= this.getMaxAge();
    }

    @Override
    protected boolean isRandomlyTicking(IBlockData var0) {
        return !this.isMaxAge(var0);
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        float var5;
        int var4;
        if (var1.getRawBrightness(var2, 0) >= 9 && (var4 = this.getAge(var0)) < this.getMaxAge() && var3.nextInt((int)(25.0f / (var5 = BlockCrops.getGrowthSpeed(this, var1, var2))) + 1) == 0) {
            var1.setBlock(var2, this.getStateForAge(var4 + 1), 2);
        }
    }

    public void growCrops(World var0, BlockPosition var1, IBlockData var2) {
        int var3 = Math.min(this.getMaxAge(), this.getAge(var2) + this.getBonemealAgeIncrease(var0));
        var0.setBlock(var1, this.getStateForAge(var3), 2);
    }

    protected int getBonemealAgeIncrease(World var0) {
        return MathHelper.nextInt(var0.random, 2, 5);
    }

    protected static float getGrowthSpeed(Block var0, IBlockAccess var1, BlockPosition var2) {
        boolean var10;
        Object var8;
        float var3 = 1.0f;
        BlockPosition var4 = var2.below();
        for (int var5 = -1; var5 <= 1; ++var5) {
            for (int var6 = -1; var6 <= 1; ++var6) {
                float var7 = 0.0f;
                var8 = var1.getBlockState(var4.offset(var5, 0, var6));
                if (((BlockBase.BlockData)var8).is(Blocks.FARMLAND)) {
                    var7 = 1.0f;
                    if (((IBlockDataHolder)var8).getValue(BlockSoil.MOISTURE) > 0) {
                        var7 = 3.0f;
                    }
                }
                if (var5 != 0 || var6 != 0) {
                    var7 /= 4.0f;
                }
                var3 += var7;
            }
        }
        BlockPosition var5 = var2.north();
        BlockPosition var6 = var2.south();
        BlockPosition var7 = var2.west();
        var8 = var2.east();
        boolean var9 = var1.getBlockState(var7).is(var0) || var1.getBlockState((BlockPosition)var8).is(var0);
        boolean bl = var10 = var1.getBlockState(var5).is(var0) || var1.getBlockState(var6).is(var0);
        if (var9 && var10) {
            var3 /= 2.0f;
        } else {
            boolean var11;
            boolean bl2 = var11 = var1.getBlockState(var7.north()).is(var0) || var1.getBlockState(((BlockPosition)var8).north()).is(var0) || var1.getBlockState(((BlockPosition)var8).south()).is(var0) || var1.getBlockState(var7.south()).is(var0);
            if (var11) {
                var3 /= 2.0f;
            }
        }
        return var3;
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return BlockCrops.hasSufficientLight(var1, var2) && super.canSurvive(var0, var1, var2);
    }

    protected static boolean hasSufficientLight(IWorldReader var0, BlockPosition var1) {
        return var0.getRawBrightness(var1, 0) >= 8;
    }

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3, InsideBlockEffectApplier var4) {
        if (var1 instanceof WorldServer) {
            WorldServer var5 = (WorldServer)var1;
            if (var3 instanceof EntityRavager && var5.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                var5.destroyBlock(var2, true, var3);
            }
        }
        super.entityInside(var0, var1, var2, var3, var4);
    }

    protected IMaterial getBaseSeedId() {
        return Items.WHEAT_SEEDS;
    }

    @Override
    protected ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2, boolean var3) {
        return new ItemStack(this.getBaseSeedId());
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return !this.isMaxAge(var2);
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        this.growCrops(var0, var2, var3);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AGE);
    }
}

