/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.EndPlatformFeature;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockEnderPortal
extends BlockTileEntity
implements Portal {
    public static final MapCodec<BlockEnderPortal> CODEC = BlockEnderPortal.simpleCodec(BlockEnderPortal::new);
    private static final VoxelShape SHAPE = Block.column(16.0, 6.0, 12.0);

    public MapCodec<BlockEnderPortal> codec() {
        return CODEC;
    }

    protected BlockEnderPortal(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityEnderPortal(var0, var1);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    protected VoxelShape getEntityInsideCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, Entity var3) {
        return var0.getShape(var1, var2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3, InsideBlockEffectApplier var4) {
        if (!var3.canUsePortal(false)) return;
        if (!var1.isClientSide() && var1.dimension() == World.END && var3 instanceof EntityPlayer) {
            EntityPlayer var5 = (EntityPlayer)var3;
            if (!var5.seenCredits) {
                var5.showEndCredits();
                return;
            }
        }
        var3.setAsInsidePortal(this, var2);
    }

    @Override
    @Nullable
    public TeleportTransition getPortalDestination(WorldServer var0, Entity var1, BlockPosition var2) {
        Set<Relative> var12;
        float var11;
        float var10;
        WorldData.a var3 = var0.getRespawnData();
        ResourceKey<World> var4 = var0.dimension();
        boolean var5 = var4 == World.END;
        ResourceKey<World> var6 = var5 ? var3.dimension() : World.END;
        BlockPosition var7 = var5 ? var3.pos() : WorldServer.END_SPAWN_POINT;
        WorldServer var8 = var0.getServer().getLevel(var6);
        if (var8 == null) {
            return null;
        }
        Vec3D var9 = var7.getBottomCenter();
        if (!var5) {
            EndPlatformFeature.createEndPlatform(var8, BlockPosition.containing(var9).below(), true);
            var10 = EnumDirection.WEST.toYRot();
            var11 = 0.0f;
            var12 = Relative.union(Relative.DELTA, Set.of(Relative.X_ROT));
            if (var1 instanceof EntityPlayer) {
                var9 = var9.subtract(0.0, 1.0, 0.0);
            }
        } else {
            var10 = var3.yaw();
            var11 = var3.pitch();
            var12 = Relative.union(Relative.DELTA, Relative.ROTATION);
            if (var1 instanceof EntityPlayer) {
                EntityPlayer var13 = (EntityPlayer)var1;
                return var13.findRespawnPositionAndUseSpawnBlock(false, TeleportTransition.DO_NOTHING);
            }
            var9 = var1.adjustSpawnLocation(var8, var7).getBottomCenter();
        }
        return new TeleportTransition(var8, var9, Vec3D.ZERO, var10, var11, var12, TeleportTransition.PLAY_PORTAL_SOUND.then(TeleportTransition.PLACE_PORTAL_TICKET));
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        double var4 = (double)var2.getX() + var3.nextDouble();
        double var6 = (double)var2.getY() + 0.8;
        double var8 = (double)var2.getZ() + var3.nextDouble();
        var1.addParticle(Particles.SMOKE, var4, var6, var8, 0.0, 0.0, 0.0);
    }

    @Override
    protected ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2, boolean var3) {
        return ItemStack.EMPTY;
    }

    @Override
    protected boolean canBeReplaced(IBlockData var0, FluidType var1) {
        return false;
    }

    @Override
    protected EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.INVISIBLE;
    }
}

