/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class BlockRepeater
extends BlockDiodeAbstract {
    public static final MapCodec<BlockRepeater> CODEC = BlockRepeater.simpleCodec(BlockRepeater::new);
    public static final BlockStateBoolean LOCKED = BlockProperties.LOCKED;
    public static final BlockStateInteger DELAY = BlockProperties.DELAY;

    public MapCodec<BlockRepeater> codec() {
        return CODEC;
    }

    protected BlockRepeater(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(DELAY, 1)).setValue(LOCKED, false)).setValue(POWERED, false));
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        if (!var3.getAbilities().mayBuild) {
            return EnumInteractionResult.PASS;
        }
        var1.setBlock(var2, (IBlockData)var0.cycle(DELAY), 3);
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    protected int getDelay(IBlockData var0) {
        return var0.getValue(DELAY) * 2;
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        IBlockData var1 = super.getStateForPlacement(var0);
        return (IBlockData)var1.setValue(LOCKED, this.isLocked(var0.getLevel(), var0.getClickedPos(), var1));
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var4 == EnumDirection.DOWN && !this.canSurviveOn(var1, var5, var6)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (!var1.isClientSide() && var4.getAxis() != ((EnumDirection)var0.getValue(FACING)).getAxis()) {
            return (IBlockData)var0.setValue(LOCKED, this.isLocked(var1, var3, var0));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    public boolean isLocked(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return this.getAlternateSignal(var0, var1, var2) > 0;
    }

    @Override
    protected boolean sideInputDiodesOnly() {
        return true;
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        if (!var0.getValue(POWERED).booleanValue()) {
            return;
        }
        EnumDirection var4 = (EnumDirection)var0.getValue(FACING);
        double var5 = (double)var2.getX() + 0.5 + (var3.nextDouble() - 0.5) * 0.2;
        double var7 = (double)var2.getY() + 0.4 + (var3.nextDouble() - 0.5) * 0.2;
        double var9 = (double)var2.getZ() + 0.5 + (var3.nextDouble() - 0.5) * 0.2;
        float var11 = -5.0f;
        if (var3.nextBoolean()) {
            var11 = var0.getValue(DELAY) * 2 - 1;
        }
        double var12 = (var11 /= 16.0f) * (float)var4.getStepX();
        double var14 = var11 * (float)var4.getStepZ();
        var1.addParticle(ParticleParamRedstone.REDSTONE, var5 + var12, var7, var9 + var14, 0.0, 0.0, 0.0);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, DELAY, LOCKED, POWERED);
    }
}

