/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.PointGroupO;
import com.mojang.math.Quadrant;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertyStairsShape;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockStairs
extends Block
implements IBlockWaterlogged {
    public static final MapCodec<BlockStairs> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)IBlockData.CODEC.fieldOf("base_state").forGetter(var0 -> var0.baseState), BlockStairs.propertiesCodec()).apply((Applicative)var02, BlockStairs::new));
    public static final BlockStateEnum<EnumDirection> FACING = BlockFacingHorizontal.FACING;
    public static final BlockStateEnum<BlockPropertyHalf> HALF = BlockProperties.HALF;
    public static final BlockStateEnum<BlockPropertyStairsShape> SHAPE = BlockProperties.STAIRS_SHAPE;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    private static final VoxelShape SHAPE_OUTER = VoxelShapes.or(Block.column(16.0, 0.0, 8.0), Block.box(0.0, 8.0, 0.0, 8.0, 16.0, 8.0));
    private static final VoxelShape SHAPE_STRAIGHT = VoxelShapes.or(SHAPE_OUTER, VoxelShapes.rotate(SHAPE_OUTER, PointGroupO.fromXYAngles(Quadrant.R0, Quadrant.R90)));
    private static final VoxelShape SHAPE_INNER = VoxelShapes.or(SHAPE_STRAIGHT, VoxelShapes.rotate(SHAPE_STRAIGHT, PointGroupO.fromXYAngles(Quadrant.R0, Quadrant.R90)));
    private static final Map<EnumDirection, VoxelShape> SHAPE_BOTTOM_OUTER = VoxelShapes.rotateHorizontal(SHAPE_OUTER);
    private static final Map<EnumDirection, VoxelShape> SHAPE_BOTTOM_STRAIGHT = VoxelShapes.rotateHorizontal(SHAPE_STRAIGHT);
    private static final Map<EnumDirection, VoxelShape> SHAPE_BOTTOM_INNER = VoxelShapes.rotateHorizontal(SHAPE_INNER);
    private static final Map<EnumDirection, VoxelShape> SHAPE_TOP_OUTER = VoxelShapes.rotateHorizontal(VoxelShapes.rotate(SHAPE_OUTER, PointGroupO.INVERT_Y));
    private static final Map<EnumDirection, VoxelShape> SHAPE_TOP_STRAIGHT = VoxelShapes.rotateHorizontal(VoxelShapes.rotate(SHAPE_STRAIGHT, PointGroupO.INVERT_Y));
    private static final Map<EnumDirection, VoxelShape> SHAPE_TOP_INNER = VoxelShapes.rotateHorizontal(VoxelShapes.rotate(SHAPE_INNER, PointGroupO.INVERT_Y));
    private final Block base;
    protected final IBlockData baseState;

    public MapCodec<? extends BlockStairs> codec() {
        return CODEC;
    }

    protected BlockStairs(IBlockData var0, BlockBase.Info var1) {
        super(var1);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(HALF, BlockPropertyHalf.BOTTOM)).setValue(SHAPE, BlockPropertyStairsShape.STRAIGHT)).setValue(WATERLOGGED, false));
        this.base = var0.getBlock();
        this.baseState = var0;
    }

    @Override
    protected boolean useShapeForLightOcclusion(IBlockData var0) {
        return true;
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        boolean var4 = var0.getValue(HALF) == BlockPropertyHalf.BOTTOM;
        EnumDirection var5 = var0.getValue(FACING);
        return (switch (var0.getValue(SHAPE)) {
            default -> throw new MatchException(null, null);
            case BlockPropertyStairsShape.STRAIGHT -> {
                if (var4) {
                    yield SHAPE_BOTTOM_STRAIGHT;
                }
                yield SHAPE_TOP_STRAIGHT;
            }
            case BlockPropertyStairsShape.INNER_RIGHT, BlockPropertyStairsShape.INNER_LEFT -> {
                if (var4) {
                    yield SHAPE_BOTTOM_INNER;
                }
                yield SHAPE_TOP_INNER;
            }
            case BlockPropertyStairsShape.OUTER_LEFT, BlockPropertyStairsShape.OUTER_RIGHT -> var4 ? SHAPE_BOTTOM_OUTER : SHAPE_TOP_OUTER;
        }).get(switch (var0.getValue(SHAPE)) {
            default -> throw new MatchException(null, null);
            case BlockPropertyStairsShape.STRAIGHT, BlockPropertyStairsShape.OUTER_LEFT, BlockPropertyStairsShape.INNER_RIGHT -> var5;
            case BlockPropertyStairsShape.INNER_LEFT -> var5.getCounterClockWise();
            case BlockPropertyStairsShape.OUTER_RIGHT -> var5.getClockWise();
        });
    }

    @Override
    public float getExplosionResistance() {
        return this.base.getExplosionResistance();
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        EnumDirection var1 = var0.getClickedFace();
        BlockPosition var2 = var0.getClickedPos();
        Fluid var3 = var0.getLevel().getFluidState(var2);
        IBlockData var4 = (IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, var0.getHorizontalDirection())).setValue(HALF, var1 == EnumDirection.DOWN || var1 != EnumDirection.UP && var0.getClickLocation().y - (double)var2.getY() > 0.5 ? BlockPropertyHalf.TOP : BlockPropertyHalf.BOTTOM)).setValue(WATERLOGGED, var3.getType() == FluidTypes.WATER);
        return (IBlockData)var4.setValue(SHAPE, BlockStairs.getStairsShape(var4, var0.getLevel(), var2));
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        if (var4.getAxis().isHorizontal()) {
            return (IBlockData)var0.setValue(SHAPE, BlockStairs.getStairsShape(var0, var1, var3));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    private static BlockPropertyStairsShape getStairsShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        EnumDirection var6;
        Object var5;
        EnumDirection var3 = var0.getValue(FACING);
        IBlockData var4 = var1.getBlockState(var2.relative(var3));
        if (BlockStairs.isStairs(var4) && var0.getValue(HALF) == var4.getValue(HALF) && ((EnumDirection)(var5 = var4.getValue(FACING))).getAxis() != var0.getValue(FACING).getAxis() && BlockStairs.canTakeShape(var0, var1, var2, ((EnumDirection)var5).getOpposite())) {
            if (var5 == var3.getCounterClockWise()) {
                return BlockPropertyStairsShape.OUTER_LEFT;
            }
            return BlockPropertyStairsShape.OUTER_RIGHT;
        }
        var5 = var1.getBlockState(var2.relative(var3.getOpposite()));
        if (BlockStairs.isStairs((IBlockData)var5) && var0.getValue(HALF) == ((IBlockDataHolder)var5).getValue(HALF) && (var6 = ((IBlockDataHolder)var5).getValue(FACING)).getAxis() != var0.getValue(FACING).getAxis() && BlockStairs.canTakeShape(var0, var1, var2, var6)) {
            if (var6 == var3.getCounterClockWise()) {
                return BlockPropertyStairsShape.INNER_LEFT;
            }
            return BlockPropertyStairsShape.INNER_RIGHT;
        }
        return BlockPropertyStairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        IBlockData var4 = var1.getBlockState(var2.relative(var3));
        return !BlockStairs.isStairs(var4) || var4.getValue(FACING) != var0.getValue(FACING) || var4.getValue(HALF) != var0.getValue(HALF);
    }

    public static boolean isStairs(IBlockData var0) {
        return var0.getBlock() instanceof BlockStairs;
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        EnumDirection var2 = var0.getValue(FACING);
        BlockPropertyStairsShape var3 = var0.getValue(SHAPE);
        switch (var1) {
            case LEFT_RIGHT: {
                if (var2.getAxis() != EnumDirection.EnumAxis.Z) break;
                switch (var3) {
                    case INNER_LEFT: {
                        return (IBlockData)var0.rotate(EnumBlockRotation.CLOCKWISE_180).setValue(SHAPE, BlockPropertyStairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (IBlockData)var0.rotate(EnumBlockRotation.CLOCKWISE_180).setValue(SHAPE, BlockPropertyStairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (IBlockData)var0.rotate(EnumBlockRotation.CLOCKWISE_180).setValue(SHAPE, BlockPropertyStairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (IBlockData)var0.rotate(EnumBlockRotation.CLOCKWISE_180).setValue(SHAPE, BlockPropertyStairsShape.OUTER_LEFT);
                    }
                }
                return var0.rotate(EnumBlockRotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (var2.getAxis() != EnumDirection.EnumAxis.X) break;
                switch (var3) {
                    case INNER_LEFT: {
                        return (IBlockData)var0.rotate(EnumBlockRotation.CLOCKWISE_180).setValue(SHAPE, BlockPropertyStairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (IBlockData)var0.rotate(EnumBlockRotation.CLOCKWISE_180).setValue(SHAPE, BlockPropertyStairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (IBlockData)var0.rotate(EnumBlockRotation.CLOCKWISE_180).setValue(SHAPE, BlockPropertyStairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (IBlockData)var0.rotate(EnumBlockRotation.CLOCKWISE_180).setValue(SHAPE, BlockPropertyStairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return var0.rotate(EnumBlockRotation.CLOCKWISE_180);
                    }
                }
                break;
            }
        }
        return super.mirror(var0, var1);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, HALF, SHAPE, WATERLOGGED);
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }
}

