/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InsideBlockEffectType;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class LavaCauldronBlock
extends AbstractCauldronBlock {
    public static final MapCodec<LavaCauldronBlock> CODEC = LavaCauldronBlock.simpleCodec(LavaCauldronBlock::new);
    private static final VoxelShape SHAPE_INSIDE = Block.column(12.0, 4.0, 15.0);
    private static final VoxelShape FILLED_SHAPE = VoxelShapes.or(AbstractCauldronBlock.SHAPE, SHAPE_INSIDE);

    public MapCodec<LavaCauldronBlock> codec() {
        return CODEC;
    }

    public LavaCauldronBlock(BlockBase.Info var0) {
        super(var0, CauldronInteraction.LAVA);
    }

    @Override
    protected double getContentHeight(IBlockData var0) {
        return 0.9375;
    }

    @Override
    public boolean isFull(IBlockData var0) {
        return true;
    }

    @Override
    protected VoxelShape getEntityInsideCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, Entity var3) {
        return FILLED_SHAPE;
    }

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3, InsideBlockEffectApplier var4) {
        var4.apply(InsideBlockEffectType.CLEAR_FREEZE);
        var4.apply(InsideBlockEffectType.LAVA_IGNITE);
        var4.runAfter(InsideBlockEffectType.LAVA_IGNITE, Entity::lavaHurt);
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2, EnumDirection var3) {
        return 3;
    }
}

