/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyWallHeight;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class MossyCarpetBlock
extends Block
implements IBlockFragilePlantElement {
    public static final MapCodec<MossyCarpetBlock> CODEC = MossyCarpetBlock.simpleCodec(MossyCarpetBlock::new);
    public static final BlockStateBoolean BASE = BlockProperties.BOTTOM;
    public static final BlockStateEnum<BlockPropertyWallHeight> NORTH = BlockProperties.NORTH_WALL;
    public static final BlockStateEnum<BlockPropertyWallHeight> EAST = BlockProperties.EAST_WALL;
    public static final BlockStateEnum<BlockPropertyWallHeight> SOUTH = BlockProperties.SOUTH_WALL;
    public static final BlockStateEnum<BlockPropertyWallHeight> WEST = BlockProperties.WEST_WALL;
    public static final Map<EnumDirection, BlockStateEnum<BlockPropertyWallHeight>> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)Maps.newEnumMap(Map.of(EnumDirection.NORTH, NORTH, EnumDirection.EAST, EAST, EnumDirection.SOUTH, SOUTH, EnumDirection.WEST, WEST)));
    private final Function<IBlockData, VoxelShape> shapes;

    public MapCodec<MossyCarpetBlock> codec() {
        return CODEC;
    }

    public MossyCarpetBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(BASE, true)).setValue(NORTH, BlockPropertyWallHeight.NONE)).setValue(EAST, BlockPropertyWallHeight.NONE)).setValue(SOUTH, BlockPropertyWallHeight.NONE)).setValue(WEST, BlockPropertyWallHeight.NONE));
        this.shapes = this.makeShapes();
    }

    @Override
    protected VoxelShape getOcclusionShape(IBlockData var0) {
        return VoxelShapes.empty();
    }

    public Function<IBlockData, VoxelShape> makeShapes() {
        Map<EnumDirection, VoxelShape> var0 = VoxelShapes.rotateHorizontal(Block.boxZ(16.0, 0.0, 10.0, 0.0, 1.0));
        Map<EnumDirection, VoxelShape> var1 = VoxelShapes.rotateAll(Block.boxZ(16.0, 0.0, 1.0));
        return this.getShapeForEachState(var2 -> {
            VoxelShape var3 = var2.getValue(BASE) != false ? (VoxelShape)var1.get(EnumDirection.DOWN) : VoxelShapes.empty();
            for (Map.Entry<EnumDirection, BlockStateEnum<BlockPropertyWallHeight>> var5 : PROPERTY_BY_DIRECTION.entrySet()) {
                switch ((BlockPropertyWallHeight)var2.getValue(var5.getValue())) {
                    case NONE: {
                        break;
                    }
                    case LOW: {
                        var3 = VoxelShapes.or(var3, (VoxelShape)var0.get(var5.getKey()));
                        break;
                    }
                    case TALL: {
                        var3 = VoxelShapes.or(var3, (VoxelShape)var1.get(var5.getKey()));
                    }
                }
            }
            return var3.isEmpty() ? VoxelShapes.block() : var3;
        });
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.shapes.apply(var0);
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return var0.getValue(BASE) != false ? this.shapes.apply(this.defaultBlockState()) : VoxelShapes.empty();
    }

    @Override
    protected boolean propagatesSkylightDown(IBlockData var0) {
        return true;
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        IBlockData var3 = var1.getBlockState(var2.below());
        if (var0.getValue(BASE).booleanValue()) {
            return !var3.isAir();
        }
        return var3.is(this) && var3.getValue(BASE) != false;
    }

    private static boolean hasFaces(IBlockData var0) {
        if (var0.getValue(BASE).booleanValue()) {
            return true;
        }
        for (BlockStateEnum<BlockPropertyWallHeight> var2 : PROPERTY_BY_DIRECTION.values()) {
            if (var0.getValue(var2) == BlockPropertyWallHeight.NONE) continue;
            return true;
        }
        return false;
    }

    private static boolean canSupportAtFace(IBlockAccess var0, BlockPosition var1, EnumDirection var2) {
        if (var2 == EnumDirection.UP) {
            return false;
        }
        return MultifaceBlock.canAttachTo(var0, var1, var2);
    }

    private static IBlockData getUpdatedState(IBlockData var0, IBlockAccess var1, BlockPosition var2, boolean var3) {
        BlockBase.BlockData var4 = null;
        BlockBase.BlockData var5 = null;
        var3 |= var0.getValue(BASE).booleanValue();
        for (EnumDirection var7 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPropertyWallHeight var9;
            BlockStateEnum<BlockPropertyWallHeight> var8 = MossyCarpetBlock.getPropertyForFace(var7);
            BlockPropertyWallHeight blockPropertyWallHeight = MossyCarpetBlock.canSupportAtFace(var1, var2, var7) ? (var3 ? BlockPropertyWallHeight.LOW : var0.getValue(var8)) : (var9 = BlockPropertyWallHeight.NONE);
            if (var9 == BlockPropertyWallHeight.LOW) {
                if (var4 == null) {
                    var4 = var1.getBlockState(var2.above());
                }
                if (var4.is(Blocks.PALE_MOSS_CARPET) && var4.getValue(var8) != BlockPropertyWallHeight.NONE && !var4.getValue(BASE).booleanValue()) {
                    var9 = BlockPropertyWallHeight.TALL;
                }
                if (!var0.getValue(BASE).booleanValue()) {
                    if (var5 == null) {
                        var5 = var1.getBlockState(var2.below());
                    }
                    if (var5.is(Blocks.PALE_MOSS_CARPET) && var5.getValue(var8) == BlockPropertyWallHeight.NONE) {
                        var9 = BlockPropertyWallHeight.NONE;
                    }
                }
            }
            var0 = (IBlockData)var0.setValue(var8, var9);
        }
        return var0;
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return MossyCarpetBlock.getUpdatedState(this.defaultBlockState(), var0.getLevel(), var0.getClickedPos(), true);
    }

    public static void placeAt(GeneratorAccess var0, BlockPosition var1, RandomSource var2, int var3) {
        IBlockData var4 = Blocks.PALE_MOSS_CARPET.defaultBlockState();
        IBlockData var5 = MossyCarpetBlock.getUpdatedState(var4, var0, var1, true);
        var0.setBlock(var1, var5, var3);
        IBlockData var6 = MossyCarpetBlock.createTopperWithSideChance(var0, var1, var2::nextBoolean);
        if (!var6.isAir()) {
            var0.setBlock(var1.above(), var6, var3);
            IBlockData var7 = MossyCarpetBlock.getUpdatedState(var5, var0, var1, true);
            var0.setBlock(var1, var7, var3);
        }
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, @Nullable EntityLiving var3, ItemStack var4) {
        if (var0.isClientSide()) {
            return;
        }
        RandomSource var5 = var0.getRandom();
        IBlockData var6 = MossyCarpetBlock.createTopperWithSideChance(var0, var1, var5::nextBoolean);
        if (!var6.isAir()) {
            var0.setBlock(var1.above(), var6, 3);
        }
    }

    private static IBlockData createTopperWithSideChance(IBlockAccess var0, BlockPosition var1, BooleanSupplier var2) {
        BlockPosition var3 = var1.above();
        IBlockData var4 = var0.getBlockState(var3);
        boolean var5 = var4.is(Blocks.PALE_MOSS_CARPET);
        if (var5 && var4.getValue(BASE).booleanValue() || !var5 && !var4.canBeReplaced()) {
            return Blocks.AIR.defaultBlockState();
        }
        IBlockData var6 = (IBlockData)Blocks.PALE_MOSS_CARPET.defaultBlockState().setValue(BASE, false);
        IBlockData var7 = MossyCarpetBlock.getUpdatedState(var6, var0, var1.above(), true);
        for (EnumDirection var9 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockStateEnum<BlockPropertyWallHeight> var10 = MossyCarpetBlock.getPropertyForFace(var9);
            if (var7.getValue(var10) == BlockPropertyWallHeight.NONE || var2.getAsBoolean()) continue;
            var7 = (IBlockData)var7.setValue(var10, BlockPropertyWallHeight.NONE);
        }
        if (MossyCarpetBlock.hasFaces(var7) && var7 != var4) {
            return var7;
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (!var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        IBlockData var8 = MossyCarpetBlock.getUpdatedState(var0, var1, var3, false);
        if (!MossyCarpetBlock.hasFaces(var8)) {
            return Blocks.AIR.defaultBlockState();
        }
        return var8;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(BASE, NORTH, EAST, SOUTH, WEST);
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return switch (var1) {
            case EnumBlockRotation.CLOCKWISE_180 -> (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(EAST, var0.getValue(WEST))).setValue(SOUTH, var0.getValue(NORTH))).setValue(WEST, var0.getValue(EAST));
            case EnumBlockRotation.COUNTERCLOCKWISE_90 -> (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(EAST))).setValue(EAST, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(WEST))).setValue(WEST, var0.getValue(NORTH));
            case EnumBlockRotation.CLOCKWISE_90 -> (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(WEST))).setValue(EAST, var0.getValue(NORTH))).setValue(SOUTH, var0.getValue(EAST))).setValue(WEST, var0.getValue(SOUTH));
            default -> var0;
        };
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return switch (var1) {
            case EnumBlockMirror.LEFT_RIGHT -> (IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(NORTH));
            case EnumBlockMirror.FRONT_BACK -> (IBlockData)((IBlockData)var0.setValue(EAST, var0.getValue(WEST))).setValue(WEST, var0.getValue(EAST));
            default -> super.mirror(var0, var1);
        };
    }

    @Nullable
    public static BlockStateEnum<BlockPropertyWallHeight> getPropertyForFace(EnumDirection var0) {
        return PROPERTY_BY_DIRECTION.get(var0);
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return var2.getValue(BASE) != false && !MossyCarpetBlock.createTopperWithSideChance(var0, var1, () -> true).isAir();
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        IBlockData var4 = MossyCarpetBlock.createTopperWithSideChance(var0, var2, () -> true);
        if (!var4.isAir()) {
            var0.setBlock(var2.above(), var4, 3);
        }
    }
}

