/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;

public interface SelectableSlotContainer {
    public int getRows();

    public int getColumns();

    default public OptionalInt getHitSlot(MovingObjectPositionBlock var02, EnumDirection var1) {
        return SelectableSlotContainer.getRelativeHitCoordinatesForBlockFace(var02, var1).map(var0 -> {
            int var1 = SelectableSlotContainer.getSection(1.0f - var0.y, this.getRows());
            int var2 = SelectableSlotContainer.getSection(var0.x, this.getColumns());
            return OptionalInt.of(var2 + var1 * this.getColumns());
        }).orElseGet(OptionalInt::empty);
    }

    private static Optional<Vec2F> getRelativeHitCoordinatesForBlockFace(MovingObjectPositionBlock var0, EnumDirection var1) {
        EnumDirection var2 = var0.getDirection();
        if (var1 != var2) {
            return Optional.empty();
        }
        BlockPosition var3 = var0.getBlockPos().relative(var2);
        Vec3D var4 = var0.getLocation().subtract(var3.getX(), var3.getY(), var3.getZ());
        double var5 = var4.x();
        double var7 = var4.y();
        double var9 = var4.z();
        return switch (var2) {
            default -> throw new MatchException(null, null);
            case EnumDirection.NORTH -> Optional.of(new Vec2F((float)(1.0 - var5), (float)var7));
            case EnumDirection.SOUTH -> Optional.of(new Vec2F((float)var5, (float)var7));
            case EnumDirection.WEST -> Optional.of(new Vec2F((float)var9, (float)var7));
            case EnumDirection.EAST -> Optional.of(new Vec2F((float)(1.0 - var9), (float)var7));
            case EnumDirection.DOWN, EnumDirection.UP -> Optional.empty();
        };
    }

    public static int getSection(float var0, int var1) {
        float var2 = var0 * 16.0f;
        float var3 = 16.0f / (float)var1;
        return MathHelper.clamp(MathHelper.floor(var2 / var3), 0, var1 - 1);
    }
}

