/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class BrushableBlockEntity
extends TileEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String LOOT_TABLE_TAG = "LootTable";
    private static final String LOOT_TABLE_SEED_TAG = "LootTableSeed";
    private static final String HIT_DIRECTION_TAG = "hit_direction";
    private static final String ITEM_TAG = "item";
    private static final int BRUSH_COOLDOWN_TICKS = 10;
    private static final int BRUSH_RESET_TICKS = 40;
    private static final int REQUIRED_BRUSHES_TO_BREAK = 10;
    private int brushCount;
    private long brushCountResetsAtTick;
    private long coolDownEndsAtTick;
    public ItemStack item = ItemStack.EMPTY;
    @Nullable
    private EnumDirection hitDirection;
    @Nullable
    public ResourceKey<LootTable> lootTable;
    public long lootTableSeed;

    public BrushableBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.BRUSHABLE_BLOCK, var0, var1);
    }

    public boolean brush(long var0, WorldServer var2, EntityLiving var3, EnumDirection var4, ItemStack var5) {
        if (this.hitDirection == null) {
            this.hitDirection = var4;
        }
        this.brushCountResetsAtTick = var0 + 40L;
        if (var0 < this.coolDownEndsAtTick) {
            return false;
        }
        this.coolDownEndsAtTick = var0 + 10L;
        this.unpackLootTable(var2, var3, var5);
        int var6 = this.getCompletionState();
        if (++this.brushCount >= 10) {
            this.brushingCompleted(var2, var3, var5);
            return true;
        }
        var2.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), 2);
        int var7 = this.getCompletionState();
        if (var6 != var7) {
            IBlockData var8 = this.getBlockState();
            IBlockData var9 = (IBlockData)var8.setValue(BlockProperties.DUSTED, var7);
            var2.setBlock(this.getBlockPos(), var9, 3);
        }
        return false;
    }

    private void unpackLootTable(WorldServer var0, EntityLiving var1, ItemStack var2) {
        Object var4;
        if (this.lootTable == null) {
            return;
        }
        LootTable var3 = var0.getServer().reloadableRegistries().getLootTable(this.lootTable);
        if (var1 instanceof EntityPlayer) {
            var4 = (EntityPlayer)var1;
            CriterionTriggers.GENERATE_LOOT.trigger((EntityPlayer)var4, this.lootTable);
        }
        var4 = new LootParams.a(var0).withParameter(LootContextParameters.ORIGIN, Vec3D.atCenterOf(this.worldPosition)).withLuck(var1.getLuck()).withParameter(LootContextParameters.THIS_ENTITY, var1).withParameter(LootContextParameters.TOOL, var2).create(LootContextParameterSets.ARCHAEOLOGY);
        ObjectArrayList<ItemStack> var5 = var3.getRandomItems((LootParams)var4, this.lootTableSeed);
        this.item = switch (var5.size()) {
            case 0 -> ItemStack.EMPTY;
            case 1 -> (ItemStack)var5.getFirst();
            default -> {
                LOGGER.warn("Expected max 1 loot from loot table {}, but got {}", (Object)this.lootTable.location(), (Object)var5.size());
                yield (ItemStack)var5.getFirst();
            }
        };
        this.lootTable = null;
        this.setChanged();
    }

    private void brushingCompleted(WorldServer var0, EntityLiving var1, ItemStack var2) {
        Block var5;
        this.dropContent(var0, var1, var2);
        IBlockData var3 = this.getBlockState();
        var0.levelEvent(3008, this.getBlockPos(), Block.getId(var3));
        Block var4 = this.getBlockState().getBlock();
        if (var4 instanceof BrushableBlock) {
            BrushableBlock var6 = (BrushableBlock)var4;
            var5 = var6.getTurnsInto();
        } else {
            var5 = Blocks.AIR;
        }
        var0.setBlock(this.worldPosition, var5.defaultBlockState(), 3);
    }

    private void dropContent(WorldServer var0, EntityLiving var1, ItemStack var2) {
        this.unpackLootTable(var0, var1, var2);
        if (!this.item.isEmpty()) {
            double var3 = EntityTypes.ITEM.getWidth();
            double var5 = 1.0 - var3;
            double var7 = var3 / 2.0;
            EnumDirection var9 = Objects.requireNonNullElse(this.hitDirection, EnumDirection.UP);
            BlockPosition var10 = this.worldPosition.relative(var9, 1);
            double var11 = (double)var10.getX() + 0.5 * var5 + var7;
            double var13 = (double)var10.getY() + 0.5 + (double)(EntityTypes.ITEM.getHeight() / 2.0f);
            double var15 = (double)var10.getZ() + 0.5 * var5 + var7;
            EntityItem var17 = new EntityItem(var0, var11, var13, var15, this.item.split(var0.random.nextInt(21) + 10));
            var17.setDeltaMovement(Vec3D.ZERO);
            var0.addFreshEntity(var17);
            this.item = ItemStack.EMPTY;
        }
    }

    public void checkReset(WorldServer var0) {
        if (this.brushCount != 0 && var0.getGameTime() >= this.brushCountResetsAtTick) {
            int var1 = this.getCompletionState();
            this.brushCount = Math.max(0, this.brushCount - 2);
            int var2 = this.getCompletionState();
            if (var1 != var2) {
                var0.setBlock(this.getBlockPos(), (IBlockData)this.getBlockState().setValue(BlockProperties.DUSTED, var2), 3);
            }
            int var3 = 4;
            this.brushCountResetsAtTick = var0.getGameTime() + 4L;
        }
        if (this.brushCount == 0) {
            this.hitDirection = null;
            this.brushCountResetsAtTick = 0L;
            this.coolDownEndsAtTick = 0L;
        } else {
            var0.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), 2);
        }
    }

    private boolean tryLoadLootTable(ValueInput var0) {
        this.lootTable = var0.read(LOOT_TABLE_TAG, LootTable.KEY_CODEC).orElse(null);
        this.lootTableSeed = var0.getLongOr(LOOT_TABLE_SEED_TAG, 0L);
        return this.lootTable != null;
    }

    private boolean trySaveLootTable(ValueOutput var0) {
        if (this.lootTable == null) {
            return false;
        }
        var0.store(LOOT_TABLE_TAG, LootTable.KEY_CODEC, this.lootTable);
        if (this.lootTableSeed != 0L) {
            var0.putLong(LOOT_TABLE_SEED_TAG, this.lootTableSeed);
        }
        return true;
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        NBTTagCompound var1 = super.getUpdateTag(var0);
        var1.storeNullable(HIT_DIRECTION_TAG, EnumDirection.LEGACY_ID_CODEC, this.hitDirection);
        if (!this.item.isEmpty()) {
            RegistryOps<NBTBase> var2 = var0.createSerializationContext(DynamicOpsNBT.INSTANCE);
            var1.store(ITEM_TAG, ItemStack.CODEC, var2, this.item);
        }
        return var1;
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    protected void loadAdditional(ValueInput var0) {
        super.loadAdditional(var0);
        this.item = !this.tryLoadLootTable(var0) ? var0.read(ITEM_TAG, ItemStack.CODEC).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
        this.hitDirection = var0.read(HIT_DIRECTION_TAG, EnumDirection.LEGACY_ID_CODEC).orElse(null);
    }

    @Override
    protected void saveAdditional(ValueOutput var0) {
        super.saveAdditional(var0);
        if (!this.trySaveLootTable(var0) && !this.item.isEmpty()) {
            var0.store(ITEM_TAG, ItemStack.CODEC, this.item);
        }
    }

    public void setLootTable(ResourceKey<LootTable> var0, long var1) {
        this.lootTable = var0;
        this.lootTableSeed = var1;
    }

    private int getCompletionState() {
        if (this.brushCount == 0) {
            return 0;
        }
        if (this.brushCount < 3) {
            return 1;
        }
        if (this.brushCount < 6) {
            return 2;
        }
        return 3;
    }

    @Nullable
    public EnumDirection getHitDirection() {
        return this.hitDirection;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

