/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.coppergolem.CopperGolem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.block.CopperGolemStatueBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;

public class CopperGolemStatueBlockEntity
extends TileEntity {
    public CopperGolemStatueBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.COPPER_GOLEM_STATUE, var0, var1);
    }

    public void createStatue(CopperGolem var0) {
        this.setComponents(DataComponentMap.builder().addAll(this.components()).set(DataComponents.CUSTOM_NAME, var0.getCustomName()).build());
        super.setChanged();
    }

    @Nullable
    public CopperGolem removeStatue(IBlockData var0) {
        CopperGolem var1 = EntityTypes.COPPER_GOLEM.create(this.level, EntitySpawnReason.TRIGGERED);
        if (var1 != null) {
            var1.setCustomName(this.components().get(DataComponents.CUSTOM_NAME));
            return this.initCopperGolem(var0, var1);
        }
        return null;
    }

    private CopperGolem initCopperGolem(IBlockData var0, CopperGolem var1) {
        BlockPosition var2 = this.getBlockPos();
        var1.snapTo(var2.getCenter().x, var2.getY(), var2.getCenter().z, var0.getValue(CopperGolemStatueBlock.FACING).toYRot(), 0.0f);
        var1.yHeadRot = var1.getYRot();
        var1.yBodyRot = var1.getYRot();
        var1.playSpawnSound();
        return var1;
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    public ItemStack getItem(ItemStack var0, CopperGolemStatueBlock.a var1) {
        var0.applyComponents(this.collectComponents());
        var0.set(DataComponents.BLOCK_STATE, BlockItemStateProperties.EMPTY.with(CopperGolemStatueBlock.POSE, var1));
        return var0;
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

