/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.WorldGenFeaturePieces;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.INamable;
import net.minecraft.world.level.block.BlockJigsaw;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class TileEntityJigsaw
extends TileEntity {
    public static final Codec<ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate>> POOL_CODEC = ResourceKey.codec(Registries.TEMPLATE_POOL);
    public static final MinecraftKey EMPTY_ID = MinecraftKey.withDefaultNamespace("empty");
    private static final int DEFAULT_PLACEMENT_PRIORITY = 0;
    private static final int DEFAULT_SELECTION_PRIORITY = 0;
    public static final String TARGET = "target";
    public static final String POOL = "pool";
    public static final String JOINT = "joint";
    public static final String PLACEMENT_PRIORITY = "placement_priority";
    public static final String SELECTION_PRIORITY = "selection_priority";
    public static final String NAME = "name";
    public static final String FINAL_STATE = "final_state";
    public static final String DEFAULT_FINAL_STATE = "minecraft:air";
    private MinecraftKey name = EMPTY_ID;
    private MinecraftKey target = EMPTY_ID;
    private ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> pool = WorldGenFeaturePieces.EMPTY;
    private JointType joint = JointType.ROLLABLE;
    private String finalState = "minecraft:air";
    private int placementPriority = 0;
    private int selectionPriority = 0;

    public TileEntityJigsaw(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.JIGSAW, var0, var1);
    }

    public MinecraftKey getName() {
        return this.name;
    }

    public MinecraftKey getTarget() {
        return this.target;
    }

    public ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> getPool() {
        return this.pool;
    }

    public String getFinalState() {
        return this.finalState;
    }

    public JointType getJoint() {
        return this.joint;
    }

    public int getPlacementPriority() {
        return this.placementPriority;
    }

    public int getSelectionPriority() {
        return this.selectionPriority;
    }

    public void setName(MinecraftKey var0) {
        this.name = var0;
    }

    public void setTarget(MinecraftKey var0) {
        this.target = var0;
    }

    public void setPool(ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> var0) {
        this.pool = var0;
    }

    public void setFinalState(String var0) {
        this.finalState = var0;
    }

    public void setJoint(JointType var0) {
        this.joint = var0;
    }

    public void setPlacementPriority(int var0) {
        this.placementPriority = var0;
    }

    public void setSelectionPriority(int var0) {
        this.selectionPriority = var0;
    }

    @Override
    protected void saveAdditional(ValueOutput var0) {
        super.saveAdditional(var0);
        var0.store(NAME, MinecraftKey.CODEC, this.name);
        var0.store(TARGET, MinecraftKey.CODEC, this.target);
        var0.store(POOL, POOL_CODEC, this.pool);
        var0.putString(FINAL_STATE, this.finalState);
        var0.store(JOINT, JointType.CODEC, this.joint);
        var0.putInt(PLACEMENT_PRIORITY, this.placementPriority);
        var0.putInt(SELECTION_PRIORITY, this.selectionPriority);
    }

    @Override
    protected void loadAdditional(ValueInput var0) {
        super.loadAdditional(var0);
        this.name = var0.read(NAME, MinecraftKey.CODEC).orElse(EMPTY_ID);
        this.target = var0.read(TARGET, MinecraftKey.CODEC).orElse(EMPTY_ID);
        this.pool = var0.read(POOL, POOL_CODEC).orElse(WorldGenFeaturePieces.EMPTY);
        this.finalState = var0.getStringOr(FINAL_STATE, DEFAULT_FINAL_STATE);
        this.joint = var0.read(JOINT, JointType.CODEC).orElseGet(() -> DefinedStructure.getDefaultJointType(this.getBlockState()));
        this.placementPriority = var0.getIntOr(PLACEMENT_PRIORITY, 0);
        this.selectionPriority = var0.getIntOr(SELECTION_PRIORITY, 0);
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        return this.saveCustomOnly(var0);
    }

    public void generate(WorldServer var0, int var1, boolean var2) {
        BlockPosition var3 = this.getBlockPos().relative(this.getBlockState().getValue(BlockJigsaw.ORIENTATION).front());
        HolderLookup.b var4 = var0.registryAccess().lookupOrThrow(Registries.TEMPLATE_POOL);
        Holder.c var5 = var4.getOrThrow(this.pool);
        WorldGenFeatureDefinedStructureJigsawPlacement.generateJigsaw(var0, var5, this.target, var1, var3, var2);
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }

    public static final class JointType
    extends Enum<JointType>
    implements INamable {
        public static final /* enum */ JointType ROLLABLE = new JointType("rollable");
        public static final /* enum */ JointType ALIGNED = new JointType("aligned");
        public static final INamable.a<JointType> CODEC;
        private final String name;
        private static final /* synthetic */ JointType[] e;

        public static JointType[] values() {
            return (JointType[])e.clone();
        }

        public static JointType valueOf(String var0) {
            return Enum.valueOf(JointType.class, var0);
        }

        private JointType(String var2) {
            this.name = var2;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public IChatBaseComponent getTranslatedName() {
            return IChatBaseComponent.translatable("jigsaw_block.joint." + this.name);
        }

        private static /* synthetic */ JointType[] b() {
            return new JointType[]{ROLLABLE, ALIGNED};
        }

        static {
            e = JointType.b();
            CODEC = INamable.fromEnum(JointType::values);
        }
    }
}

