/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.vault;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.INamable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.vault.VaultBlockEntity;
import net.minecraft.world.level.block.entity.vault.VaultConfig;
import net.minecraft.world.level.block.entity.vault.VaultServerData;
import net.minecraft.world.level.block.entity.vault.VaultSharedData;
import net.minecraft.world.phys.Vec3D;

public sealed class VaultState
extends Enum<VaultState>
implements INamable {
    public static final /* enum */ VaultState INACTIVE = new VaultState("inactive", a.HALF_LIT){

        @Override
        protected void onEnter(WorldServer var0, BlockPosition var1, VaultConfig var2, VaultSharedData var3, boolean var4) {
            var3.setDisplayItem(ItemStack.EMPTY);
            var0.levelEvent(3016, var1, var4 ? 1 : 0);
        }
    };
    public static final /* enum */ VaultState ACTIVE = new VaultState("active", a.LIT){

        @Override
        protected void onEnter(WorldServer var0, BlockPosition var1, VaultConfig var2, VaultSharedData var3, boolean var4) {
            if (!var3.hasDisplayItem()) {
                VaultBlockEntity.b.cycleDisplayItemFromLootTable(var0, this, var2, var3, var1);
            }
            var0.levelEvent(3015, var1, var4 ? 1 : 0);
        }
    };
    public static final /* enum */ VaultState UNLOCKING = new VaultState("unlocking", a.LIT){

        @Override
        protected void onEnter(WorldServer var0, BlockPosition var1, VaultConfig var2, VaultSharedData var3, boolean var4) {
            var0.playSound(null, var1, SoundEffects.VAULT_INSERT_ITEM, SoundCategory.BLOCKS);
        }
    };
    public static final /* enum */ VaultState EJECTING = new VaultState("ejecting", a.LIT){

        @Override
        protected void onEnter(WorldServer var0, BlockPosition var1, VaultConfig var2, VaultSharedData var3, boolean var4) {
            var0.playSound(null, var1, SoundEffects.VAULT_OPEN_SHUTTER, SoundCategory.BLOCKS);
        }

        @Override
        protected void onExit(WorldServer var0, BlockPosition var1, VaultConfig var2, VaultSharedData var3) {
            var0.playSound(null, var1, SoundEffects.VAULT_CLOSE_SHUTTER, SoundCategory.BLOCKS);
        }
    };
    private static final int UPDATE_CONNECTED_PLAYERS_TICK_RATE = 20;
    private static final int DELAY_BETWEEN_EJECTIONS_TICKS = 20;
    private static final int DELAY_AFTER_LAST_EJECTION_TICKS = 20;
    private static final int DELAY_BEFORE_FIRST_EJECTION_TICKS = 20;
    private final String stateName;
    private final a lightLevel;
    private static final /* synthetic */ VaultState[] k;

    public static VaultState[] values() {
        return (VaultState[])k.clone();
    }

    public static VaultState valueOf(String var0) {
        return Enum.valueOf(VaultState.class, var0);
    }

    VaultState(String var2, a var3) {
        this.stateName = var2;
        this.lightLevel = var3;
    }

    @Override
    public String getSerializedName() {
        return this.stateName;
    }

    public int lightLevel() {
        return this.lightLevel.value;
    }

    public VaultState tickAndGetNext(WorldServer var0, BlockPosition var1, VaultConfig var2, VaultServerData var3, VaultSharedData var4) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> VaultState.updateStateForConnectedPlayers(var0, var1, var2, var3, var4, var2.activationRange());
            case 1 -> VaultState.updateStateForConnectedPlayers(var0, var1, var2, var3, var4, var2.deactivationRange());
            case 2 -> {
                var3.pauseStateUpdatingUntil(var0.getGameTime() + 20L);
                yield EJECTING;
            }
            case 3 -> {
                if (var3.getItemsToEject().isEmpty()) {
                    var3.markEjectionFinished();
                    yield VaultState.updateStateForConnectedPlayers(var0, var1, var2, var3, var4, var2.deactivationRange());
                }
                float var5 = var3.ejectionProgress();
                this.ejectResultItem(var0, var1, var3.popNextItemToEject(), var5);
                var4.setDisplayItem(var3.getNextItemToEject());
                boolean var6 = var3.getItemsToEject().isEmpty();
                int var7 = var6 ? 20 : 20;
                var3.pauseStateUpdatingUntil(var0.getGameTime() + (long)var7);
                yield EJECTING;
            }
        };
    }

    private static VaultState updateStateForConnectedPlayers(WorldServer var0, BlockPosition var1, VaultConfig var2, VaultServerData var3, VaultSharedData var4, double var5) {
        var4.updateConnectedPlayersWithinRange(var0, var1, var3, var2, var5);
        var3.pauseStateUpdatingUntil(var0.getGameTime() + 20L);
        return var4.hasConnectedPlayers() ? ACTIVE : INACTIVE;
    }

    public void onTransition(WorldServer var0, BlockPosition var1, VaultState var2, VaultConfig var3, VaultSharedData var4, boolean var5) {
        this.onExit(var0, var1, var3, var4);
        var2.onEnter(var0, var1, var3, var4, var5);
    }

    protected void onEnter(WorldServer var0, BlockPosition var1, VaultConfig var2, VaultSharedData var3, boolean var4) {
    }

    protected void onExit(WorldServer var0, BlockPosition var1, VaultConfig var2, VaultSharedData var3) {
    }

    private void ejectResultItem(WorldServer var0, BlockPosition var1, ItemStack var2, float var3) {
        DispenseBehaviorItem.spawnItem(var0, var2, 2, EnumDirection.UP, Vec3D.atBottomCenterOf(var1).relative(EnumDirection.UP, 1.2));
        var0.levelEvent(3017, var1, 0);
        var0.playSound(null, var1, SoundEffects.VAULT_EJECT_ITEM, SoundCategory.BLOCKS, 1.0f, 0.8f + 0.4f * var3);
    }

    private static /* synthetic */ VaultState[] b() {
        return new VaultState[]{INACTIVE, ACTIVE, UNLOCKING, EJECTING};
    }

    static {
        k = VaultState.b();
    }

    static final class a
    extends Enum<a> {
        public static final /* enum */ a HALF_LIT = new a(6);
        public static final /* enum */ a LIT = new a(12);
        final int value;
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(int var2) {
            this.value = var2;
        }

        private static /* synthetic */ a[] a() {
            return new a[]{HALF_LIT, LIT};
        }

        static {
            d = a.a();
        }
    }
}

